/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.fingerprint;

import hudson.BulkChange;
import hudson.model.Fingerprint;
import hudson.model.Run;
import hudson.model.Saveable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.fingerprint.ContainerRecord;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerAncestorFingerprintFacet;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerDescendantFingerprintFacet;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerFingerprintAction;
import org.jenkinsci.plugins.docker.commons.fingerprint.DockerRunFingerprintFacet;

public class DockerFingerprints {
    private static final Logger LOGGER = Logger.getLogger(DockerFingerprints.class.getName());

    private DockerFingerprints() {
    }

    @Nonnull
    public static String getFingerprintHash(@Nonnull String id) {
        if (id.indexOf("sha256:") == 0) {
            id = id.substring(7);
        }
        if (id.length() != 64) {
            throw new IllegalArgumentException("Expecting 64-char full image ID, but got " + id);
        }
        return id.substring(0, 32);
    }

    @CheckForNull
    public static Fingerprint of(@Nonnull String id) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        return jenkins != null ? (Fingerprint)jenkins.getFingerprintMap().get(DockerFingerprints.getFingerprintHash(id)) : null;
    }

    @CheckForNull
    private static Fingerprint ofNoException(@Nonnull String id) {
        try {
            return DockerFingerprints.of(id);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Cannot retrieve a fingerprint for Docker id=" + id, ex);
            return null;
        }
    }

    @Nonnull
    public static Fingerprint forImage(@CheckForNull Run<?, ?> run, @Nonnull String id) throws IOException {
        return DockerFingerprints.forImage(run, id, null);
    }

    @Nonnull
    public static Fingerprint forImage(@CheckForNull Run<?, ?> run, @Nonnull String id, @CheckForNull String name) throws IOException {
        return DockerFingerprints.forDockerInstance(run, id, name, "Docker image ");
    }

    @Deprecated
    @Nonnull
    public static Fingerprint forContainer(@CheckForNull Run<?, ?> run, @Nonnull String id) throws IOException {
        return DockerFingerprints.forContainer(run, id, null);
    }

    @Nonnull
    public static Fingerprint forContainer(@CheckForNull Run<?, ?> run, @Nonnull String id, @CheckForNull String name) throws IOException {
        return DockerFingerprints.forDockerInstance(run, id, name, "Docker container ");
    }

    @Nonnull
    private static Fingerprint forDockerInstance(@CheckForNull Run<?, ?> run, @Nonnull String id, @CheckForNull String name, @Nonnull String prefix) throws IOException {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            throw new IOException("Jenkins instance is not ready");
        }
        String imageName = prefix + (StringUtils.isNotBlank((String)name) ? name : id);
        return j.getFingerprintMap().getOrCreate(run, imageName, DockerFingerprints.getFingerprintHash(id));
    }

    @CheckForNull
    public static <TFacet extends FingerprintFacet> TFacet getFacet(@Nonnull String id, @Nonnull Class<TFacet> facetClass) {
        Fingerprint fp = DockerFingerprints.ofNoException(id);
        return fp != null ? (TFacet)DockerFingerprints.getFacet(fp, facetClass) : null;
    }

    @Nonnull
    public static <TFacet extends FingerprintFacet> Collection<TFacet> getFacets(@Nonnull String id, @Nonnull Class<TFacet> facetClass) {
        Fingerprint fp = DockerFingerprints.ofNoException(id);
        return fp != null ? DockerFingerprints.getFacets(fp, facetClass) : Collections.emptySet();
    }

    @CheckForNull
    public static <TFacet extends FingerprintFacet> TFacet getFacet(@Nonnull Fingerprint fingerprint, @Nonnull Class<TFacet> facetClass) {
        for (FingerprintFacet facet : fingerprint.getFacets()) {
            if (!facetClass.isAssignableFrom(facet.getClass())) continue;
            return (TFacet)facet;
        }
        return null;
    }

    @Nonnull
    public static <TFacet extends FingerprintFacet> Collection<TFacet> getFacets(@Nonnull Fingerprint fingerprint, @Nonnull Class<TFacet> facetClass) {
        LinkedList<FingerprintFacet> res = new LinkedList<FingerprintFacet>();
        for (FingerprintFacet facet : fingerprint.getFacets()) {
            if (!facetClass.isAssignableFrom(facet.getClass())) continue;
            res.add(facet);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRunFacet(@Nonnull ContainerRecord record, @Nonnull Run<?, ?> run) throws IOException {
        String imageId = record.getImageId();
        Fingerprint f = DockerFingerprints.forImage(run, imageId);
        Collection facets = f.getFacets();
        DockerRunFingerprintFacet runFacet = null;
        for (FingerprintFacet facet : facets) {
            if (!(facet instanceof DockerRunFingerprintFacet)) continue;
            runFacet = (DockerRunFingerprintFacet)facet;
            break;
        }
        BulkChange bc = new BulkChange((Saveable)f);
        try {
            if (runFacet == null) {
                runFacet = new DockerRunFingerprintFacet(f, System.currentTimeMillis(), imageId);
                facets.add(runFacet);
            }
            runFacet.add(record);
            runFacet.addFor(run);
            DockerFingerprintAction.addToRun(f, imageId, run);
            bc.commit();
        }
        finally {
            bc.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFromFacet(@CheckForNull String ancestorImageId, @Nonnull String descendantImageId, @Nonnull Run<?, ?> run) throws IOException {
        BulkChange bc;
        Collection facets;
        Fingerprint f;
        long timestamp = System.currentTimeMillis();
        if (ancestorImageId != null) {
            f = DockerFingerprints.forImage(run, ancestorImageId);
            facets = f.getFacets();
            DockerDescendantFingerprintFacet descendantFacet = null;
            for (FingerprintFacet facet : facets) {
                if (!(facet instanceof DockerDescendantFingerprintFacet)) continue;
                descendantFacet = (DockerDescendantFingerprintFacet)facet;
                break;
            }
            bc = new BulkChange((Saveable)f);
            try {
                if (descendantFacet == null) {
                    descendantFacet = new DockerDescendantFingerprintFacet(f, timestamp, ancestorImageId);
                    facets.add(descendantFacet);
                }
                descendantFacet.addDescendantImageId(descendantImageId);
                descendantFacet.addFor(run);
                DockerFingerprintAction.addToRun(f, ancestorImageId, run);
                bc.commit();
            }
            finally {
                bc.abort();
            }
        }
        f = DockerFingerprints.forImage(run, descendantImageId);
        facets = f.getFacets();
        DockerAncestorFingerprintFacet ancestorFacet = null;
        for (FingerprintFacet facet : facets) {
            if (!(facet instanceof DockerAncestorFingerprintFacet)) continue;
            ancestorFacet = (DockerAncestorFingerprintFacet)facet;
            break;
        }
        bc = new BulkChange((Saveable)f);
        try {
            if (ancestorFacet == null) {
                ancestorFacet = new DockerAncestorFingerprintFacet(f, timestamp, descendantImageId);
                facets.add(ancestorFacet);
            }
            if (ancestorImageId != null) {
                ancestorFacet.addAncestorImageId(ancestorImageId);
            }
            ancestorFacet.addFor(run);
            DockerFingerprintAction.addToRun(f, descendantImageId, run);
            bc.commit();
        }
        finally {
            bc.abort();
        }
    }
}

