/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import hudson.EnvVars;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.NullKeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CompositeKeyMaterialFactory
extends KeyMaterialFactory {
    private final KeyMaterialFactory[] factories;

    public CompositeKeyMaterialFactory(KeyMaterialFactory ... factories) {
        KeyMaterialFactory[] keyMaterialFactoryArray;
        if (factories == null || factories.length == 0) {
            KeyMaterialFactory[] keyMaterialFactoryArray2 = new KeyMaterialFactory[1];
            keyMaterialFactoryArray = keyMaterialFactoryArray2;
            keyMaterialFactoryArray2[0] = new NullKeyMaterialFactory();
        } else {
            keyMaterialFactoryArray = (KeyMaterialFactory[])factories.clone();
        }
        this.factories = keyMaterialFactoryArray;
    }

    @Override
    public synchronized KeyMaterialFactory contextualize(@Nonnull KeyMaterialContext context) {
        KeyMaterialFactory contextualized = super.contextualize(context);
        assert (contextualized == this);
        for (KeyMaterialFactory factory : this.factories) {
            factory.contextualize(context);
        }
        return this;
    }

    @Override
    public KeyMaterial materialize() throws IOException, InterruptedException {
        KeyMaterial[] keyMaterials = new KeyMaterial[this.factories.length];
        EnvVars env = new EnvVars();
        try {
            for (int index = 0; index < this.factories.length; ++index) {
                keyMaterials[index] = this.factories[index].materialize();
                env.putAll((Map)keyMaterials[index].env());
            }
            return new CompositeKeyMaterial(env, keyMaterials);
        }
        catch (Throwable e) {
            for (int index = keyMaterials.length - 1; index >= 0; --index) {
                try {
                    if (keyMaterials[index] == null) continue;
                    keyMaterials[index].close();
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IOException("Error materializing credentials.", e);
        }
    }

    private static final class CompositeKeyMaterial
    extends KeyMaterial
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final KeyMaterial[] keyMaterials;

        protected CompositeKeyMaterial(EnvVars envVars, KeyMaterial ... keyMaterials) {
            super(envVars);
            this.keyMaterials = keyMaterials;
        }

        @Override
        public void close() throws IOException {
            Throwable first = null;
            for (int index = this.keyMaterials.length - 1; index >= 0; --index) {
                try {
                    if (this.keyMaterials[index] == null) continue;
                    this.keyMaterials[index].close();
                    continue;
                }
                catch (Throwable e) {
                    first = first == null ? e : first;
                }
            }
            if (first != null) {
                if (first instanceof IOException) {
                    throw (IOException)first;
                }
                if (first instanceof RuntimeException) {
                    throw (RuntimeException)first;
                }
                throw new IOException("Error closing credentials.", first);
            }
        }
    }
}

