/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.fingerprint;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ContainerRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String host;
    private final String containerId;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Restored from DockerRunFingerprintFacet.readResolve")
    private transient String imageId;
    private final String containerName;
    private final long created;
    private final Map<String, String> tags;

    public ContainerRecord(@NonNull String host, @NonNull String containerId, @NonNull String imageId, @NonNull String containerName, long created, @NonNull Map<String, String> tags) {
        this.host = host;
        this.containerId = containerId;
        this.imageId = imageId;
        this.containerName = containerName;
        this.created = created;
        this.tags = new HashMap<String, String>(tags);
    }

    public String getHost() {
        return this.host;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(@NonNull String imageId) {
        this.imageId = imageId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public long getCreated() {
        return this.created;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerRecord that = (ContainerRecord)o;
        return this.containerId.equals(that.containerId);
    }

    public int hashCode() {
        return this.containerId.hashCode();
    }
}

