/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Job;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class RegistryEndpointStep
extends AbstractStepImpl {
    @Nonnull
    private final DockerRegistryEndpoint registry;

    @DataBoundConstructor
    public RegistryEndpointStep(@Nonnull DockerRegistryEndpoint registry) {
        assert (registry != null);
        this.registry = registry;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "withDockerRegistry";
        }

        public String getDisplayName() {
            return "Sets up Docker registry endpoint";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractEndpointStepExecution {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient RegistryEndpointStep step;
        @StepContextParameter
        private transient Job<?, ?> job;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;

        @Override
        protected KeyMaterialFactory newKeyMaterialFactory() throws IOException, InterruptedException {
            return this.step.registry.newKeyMaterialFactory(this.job, this.workspace.getChannel(), this.launcher, this.listener);
        }
    }
}

