/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.durabletask.executors;

import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.OneOffExecutor;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.CloudRetentionStrategy;
import hudson.slaves.EphemeralNode;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;

public final class OnceRetentionStrategy
extends CloudRetentionStrategy
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(OnceRetentionStrategy.class.getName());
    private transient boolean terminating;
    private final int idleMinutes;

    public OnceRetentionStrategy(int idleMinutes) {
        super(idleMinutes);
        this.idleMinutes = idleMinutes;
        LOGGER.fine(() -> "initialized with " + idleMinutes + "m");
    }

    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && !disabled && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit.MINUTES.toMillis(this.idleMinutes)) {
            LOGGER.log(Level.FINE, "Disconnecting {0}", c.getName());
            this.done(c);
        }
        return 1L;
    }

    public void start(AbstractCloudComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use OnceRetentionStrategy on an EphemeralNode: " + c);
        }
        super.start(c);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        LOGGER.fine(() -> "success " + executor + " " + task);
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        LOGGER.log(Level.FINE, problems, () -> "error " + executor + " " + task);
        this.done(executor);
    }

    private void done(Executor executor) {
        AbstractCloudComputer c = (AbstractCloudComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        if (executor instanceof OneOffExecutor) {
            LOGGER.log(Level.FINE, "not terminating {0} because {1} was a flyweight task", new Object[]{c.getName(), exec});
            return;
        }
        if (exec instanceof ContinuableExecutable && ((ContinuableExecutable)exec).willContinue()) {
            LOGGER.log(Level.FINE, "not terminating {0} because {1} says it will be continued", new Object[]{c.getName(), exec});
            return;
        }
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done(AbstractCloudComputer<?> c) {
        c.setAcceptingTasks(false);
        OnceRetentionStrategy onceRetentionStrategy = this;
        synchronized (onceRetentionStrategy) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        LOGGER.log(Level.FINE, new Throwable(), () -> "terminating " + c + " idle? " + c.isIdle() + " idleStartMilliseconds=" + new Date(c.getIdleStartMilliseconds()));
        Computer.threadPoolForRemoting.submit(() -> Queue.withLock(() -> {
            try {
                AbstractCloudSlave node = c.getNode();
                if (node != null) {
                    LOGGER.fine(() -> "terminating " + c + " now");
                    node.terminate();
                }
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
                OnceRetentionStrategy onceRetentionStrategy = this;
                synchronized (onceRetentionStrategy) {
                    this.terminating = false;
                }
            }
        }));
    }
}

