/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import hudson.plugins.ec2.ssh.verifiers.HostKeyHelper;
import hudson.plugins.ec2.ssh.verifiers.Messages;
import hudson.plugins.ec2.ssh.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.localizer.Localizable;

public class CheckNewSoftStrategy
extends SshHostKeyVerificationStrategy {
    private static final Logger LOGGER = Logger.getLogger(CheckNewSoftStrategy.class.getName());

    @Override
    public boolean verify(EC2Computer computer, HostKey hostKey, TaskListener listener) throws IOException {
        HostKey existingHostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
        if (null == existingHostKey) {
            HostKey consoleHostKey = this.getHostKeyFromConsole(LOGGER, computer, hostKey.getAlgorithm());
            if (hostKey.equals(consoleHostKey)) {
                HostKeyHelper.getInstance().saveHostKey((Computer)computer, hostKey);
                EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), String.format("The SSH key %s %s has been successfully checked against the instance console for connections to %s", hostKey.getAlgorithm(), hostKey.getFingerprint(), computer.getName()));
                return true;
            }
            if (consoleHostKey == null) {
                EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), String.format("The instance console is blank. Cannot check the key. The connection to %s is not allowed", computer.getName()));
                return false;
            }
            if (consoleHostKey.getKey().length == 0) {
                EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), String.format("The SSH key (%s %s) presented by the instance has not been found on the instance console. Cannot check the key but the connection to %s is allowed", hostKey.getAlgorithm(), hostKey.getFingerprint(), computer.getName()));
                HostKeyHelper.getInstance().saveHostKey((Computer)computer, hostKey);
                return true;
            }
            EC2Cloud.log(LOGGER, Level.WARNING, computer.getListener(), String.format("The SSH key (%s %s) presented by the instance is different from the one printed out on the instance console (%s %s). The connection to %s is closed to prevent a possible man-in-the-middle attack", hostKey.getAlgorithm(), hostKey.getFingerprint(), consoleHostKey.getAlgorithm(), consoleHostKey.getFingerprint(), computer.getName()));
            computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages._OfflineCause_SSHKeyCheckFailed()));
            return false;
        }
        if (existingHostKey.equals(hostKey)) {
            EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), String.format("Connection allowed after the host key has been verified", new Object[0]));
            return true;
        }
        EC2Cloud.log(LOGGER, Level.WARNING, computer.getListener(), String.format("The SSH key (%s) presented by the instance has changed since first saved (%s). The connection to %s is closed to prevent a possible man-in-the-middle attack", hostKey.getFingerprint(), existingHostKey.getFingerprint(), computer.getName()));
        computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages._OfflineCause_SSHKeyCheckFailed()));
        return false;
    }
}

