/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.HostKeyVerificationStrategyEnum;
import hudson.plugins.ec2.PluginImpl;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.ssh.verifiers.Messages;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class SshHostKeyVerificationAdministrativeMonitor
extends AdministrativeMonitor {
    private static final int MAX_TEMPLATES_FOUND = 5;
    List<String> veryInsecureTemplates = new ArrayList<String>(5);
    List<String> insecureTemplates = new ArrayList<String>(5);

    public String getDisplayName() {
        return Messages.AdminMonitor_DisplayName();
    }

    public String getVeryInsecureTemplates() {
        return this.veryInsecureTemplates.stream().collect(Collectors.joining(", "));
    }

    public String getInsecureTemplates() {
        return this.insecureTemplates.stream().collect(Collectors.joining(", "));
    }

    public boolean showVeryInsecureTemplates() {
        return !this.veryInsecureTemplates.isEmpty();
    }

    public boolean showInsecureTemplates() {
        PluginImpl plugin = PluginImpl.get();
        if (plugin == null) {
            return true;
        }
        Instant whenDismissed = Instant.ofEpochMilli(plugin.getDismissInsecureMessages());
        return (whenDismissed.equals(Instant.EPOCH) || Instant.now().isBefore(whenDismissed)) && !this.insecureTemplates.isEmpty();
    }

    public boolean isActivated() {
        boolean maxTemplatesReached = false;
        ListIterator cloudIterator = Jenkins.get().clouds.listIterator();
        this.veryInsecureTemplates.clear();
        this.insecureTemplates.clear();
        while (cloudIterator.hasNext() && !maxTemplatesReached) {
            Cloud cloud = (Cloud)cloudIterator.next();
            if (!(cloud instanceof EC2Cloud)) continue;
            maxTemplatesReached = this.gatherInsecureTemplate((EC2Cloud)cloud);
        }
        return this.showInsecureTemplates() || this.showVeryInsecureTemplates();
    }

    private boolean gatherInsecureTemplate(EC2Cloud cloud) {
        List<SlaveTemplate> templates = cloud.getTemplates();
        for (SlaveTemplate template : templates) {
            if (!template.isUnixSlave() || !template.isMacAgent()) continue;
            HostKeyVerificationStrategyEnum strategy = template.getHostKeyVerificationStrategy();
            if (this.veryInsecureTemplates.size() < 5 && strategy.equals((Object)HostKeyVerificationStrategyEnum.OFF)) {
                this.veryInsecureTemplates.add(template.getDisplayName());
            } else if (this.insecureTemplates.size() < 5 && !strategy.equals((Object)HostKeyVerificationStrategyEnum.CHECK_NEW_HARD)) {
                this.insecureTemplates.add(template.getDisplayName());
            }
            if (this.veryInsecureTemplates.size() < 5 && this.insecureTemplates.size() < 5) continue;
            return true;
        }
        return false;
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String dismiss, @QueryParameter String dismissAllMessages) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (dismiss != null) {
            PluginImpl.get().saveDismissInsecureMessages(System.currentTimeMillis());
        }
        if (dismissAllMessages != null) {
            this.disable(true);
        }
        return HttpResponses.forwardToPreviousPage();
    }
}

