/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.Map;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MinimumNumberOfInstancesTimeRangeConfig {
    private String minimumNoInstancesActiveTimeRangeFrom;
    private String minimumNoInstancesActiveTimeRangeTo;
    @Deprecated
    private transient Map<String, Boolean> minimumNoInstancesActiveTimeRangeDays;
    private Boolean monday;
    private Boolean tuesday;
    private Boolean wednesday;
    private Boolean thursday;
    private Boolean friday;
    private Boolean saturday;
    private Boolean sunday;

    @DataBoundConstructor
    public MinimumNumberOfInstancesTimeRangeConfig() {
    }

    protected Object readResolve() {
        if (this.minimumNoInstancesActiveTimeRangeDays != null && !this.minimumNoInstancesActiveTimeRangeDays.isEmpty()) {
            this.monday = this.minimumNoInstancesActiveTimeRangeDays.get("monday");
            this.tuesday = this.minimumNoInstancesActiveTimeRangeDays.get("tuesday");
            this.wednesday = this.minimumNoInstancesActiveTimeRangeDays.get("wednesday");
            this.thursday = this.minimumNoInstancesActiveTimeRangeDays.get("thursday");
            this.friday = this.minimumNoInstancesActiveTimeRangeDays.get("friday");
            this.saturday = this.minimumNoInstancesActiveTimeRangeDays.get("saturday");
            this.sunday = this.minimumNoInstancesActiveTimeRangeDays.get("sunday");
        }
        return this;
    }

    private static LocalTime getLocalTime(String value) {
        try {
            return LocalTime.parse(value, DateTimeFormatter.ofPattern("h:mm a", Locale.ENGLISH));
        }
        catch (DateTimeParseException e) {
            try {
                return LocalTime.parse(value, DateTimeFormatter.ofPattern("HH:mm", Locale.ENGLISH));
            }
            catch (DateTimeParseException dateTimeParseException) {
                return null;
            }
        }
    }

    public static void validateLocalTimeString(String value) {
        if (MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(value) == null) {
            throw new IllegalArgumentException("Value " + value + " is not valid time format, ([12:34 AM] or [23:45])");
        }
    }

    public String getMinimumNoInstancesActiveTimeRangeFrom() {
        return this.minimumNoInstancesActiveTimeRangeFrom;
    }

    @DataBoundSetter
    public void setMinimumNoInstancesActiveTimeRangeFrom(String minimumNoInstancesActiveTimeRangeFrom) {
        MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(minimumNoInstancesActiveTimeRangeFrom);
        this.minimumNoInstancesActiveTimeRangeFrom = minimumNoInstancesActiveTimeRangeFrom;
    }

    public LocalTime getMinimumNoInstancesActiveTimeRangeFromAsTime() {
        return MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(this.minimumNoInstancesActiveTimeRangeFrom);
    }

    public String getMinimumNoInstancesActiveTimeRangeTo() {
        return this.minimumNoInstancesActiveTimeRangeTo;
    }

    @DataBoundSetter
    public void setMinimumNoInstancesActiveTimeRangeTo(String minimumNoInstancesActiveTimeRangeTo) {
        MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(minimumNoInstancesActiveTimeRangeTo);
        this.minimumNoInstancesActiveTimeRangeTo = minimumNoInstancesActiveTimeRangeTo;
    }

    public LocalTime getMinimumNoInstancesActiveTimeRangeToAsTime() {
        return MinimumNumberOfInstancesTimeRangeConfig.getLocalTime(this.minimumNoInstancesActiveTimeRangeTo);
    }

    public Boolean getMonday() {
        return this.monday;
    }

    @DataBoundSetter
    public void setMonday(Boolean monday) {
        this.monday = monday;
    }

    public Boolean getTuesday() {
        return this.tuesday;
    }

    @DataBoundSetter
    public void setTuesday(Boolean tuesday) {
        this.tuesday = tuesday;
    }

    public Boolean getWednesday() {
        return this.wednesday;
    }

    @DataBoundSetter
    public void setWednesday(Boolean wednesday) {
        this.wednesday = wednesday;
    }

    public Boolean getThursday() {
        return this.thursday;
    }

    @DataBoundSetter
    public void setThursday(Boolean thursday) {
        this.thursday = thursday;
    }

    public Boolean getFriday() {
        return this.friday;
    }

    @DataBoundSetter
    public void setFriday(Boolean friday) {
        this.friday = friday;
    }

    public Boolean getSaturday() {
        return this.saturday;
    }

    @DataBoundSetter
    public void setSaturday(Boolean saturday) {
        this.saturday = saturday;
    }

    public Boolean getSunday() {
        return this.sunday;
    }

    @DataBoundSetter
    public void setSunday(Boolean sunday) {
        this.sunday = sunday;
    }

    public boolean getDay(String day) {
        switch (day.toLowerCase()) {
            case "monday": {
                return Boolean.TRUE.equals(this.monday);
            }
            case "tuesday": {
                return Boolean.TRUE.equals(this.tuesday);
            }
            case "wednesday": {
                return Boolean.TRUE.equals(this.wednesday);
            }
            case "thursday": {
                return Boolean.TRUE.equals(this.thursday);
            }
            case "friday": {
                return Boolean.TRUE.equals(this.friday);
            }
            case "saturday": {
                return Boolean.TRUE.equals(this.saturday);
            }
            case "sunday": {
                return Boolean.TRUE.equals(this.sunday);
            }
        }
        throw new IllegalArgumentException("Can only get days");
    }
}

