/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm;

import hudson.plugins.ec2.win.winrm.WinRMClient;
import hudson.plugins.ec2.win.winrm.WindowsProcess;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class WinRM {
    private static final Logger log = Logger.getLogger(WinRM.class.getName());
    private final String host;
    private final String username;
    private final String password;
    private int timeout = 60;
    private final boolean allowSelfSignedCertificate;
    private boolean useHTTPS;

    @Deprecated
    public WinRM(String host, String username, String password) {
        this(host, username, password, true);
    }

    public WinRM(String host, String username, String password, boolean allowSelfSignedCertificate) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.allowSelfSignedCertificate = allowSelfSignedCertificate;
    }

    public void ping() throws IOException {
        WinRMClient client = new WinRMClient(this.buildURL(), this.username, this.password, this.allowSelfSignedCertificate);
        client.setTimeout(WinRM.secToDuration(this.timeout));
        client.setUseHTTPS(this.isUseHTTPS());
        try {
            client.openShell();
        }
        finally {
            try {
                client.deleteShell();
            }
            catch (Exception exception) {}
        }
    }

    public WindowsProcess execute(String commandLine) {
        WinRMClient client = new WinRMClient(this.buildURL(), this.username, this.password, this.allowSelfSignedCertificate);
        client.setTimeout(WinRM.secToDuration(this.timeout));
        client.setUseHTTPS(this.isUseHTTPS());
        try {
            client.openShell();
            client.executeCommand(commandLine);
            return new WindowsProcess(client, commandLine);
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot execute command " + commandLine + " on " + this, exc);
        }
    }

    public URL buildURL() {
        String scheme = this.useHTTPS ? "https" : "http";
        int port = this.useHTTPS ? 5986 : 5985;
        try {
            return new URL(scheme, this.host, port, "/wsman");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid winrm url");
        }
    }

    public boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    public void setUseHTTPS(boolean useHTTPS) {
        this.useHTTPS = useHTTPS;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private static String secToDuration(int seconds) {
        StringBuilder iso = new StringBuilder("P");
        if (seconds > 604800) {
            int weeks = seconds / 604800;
            seconds -= 604800 * weeks;
            iso.append(weeks).append('W');
        }
        if (seconds > 86400) {
            int days = seconds / 86400;
            seconds -= 86400 * days;
            iso.append(days).append('D');
        }
        if (seconds > 0) {
            iso.append('T');
            if (seconds > 3600) {
                int hours = seconds / 3600;
                seconds -= 3600 * hours;
                iso.append(hours).append('H');
            }
            if (seconds > 60) {
                int minutes = seconds / 60;
                seconds -= 60 * minutes;
                iso.append(minutes).append('M');
            }
            iso.append(seconds).append('S');
        }
        return iso.toString();
    }
}

