/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm.request;

import hudson.plugins.ec2.win.winrm.request.AbstractWinRMRequest;
import hudson.plugins.ec2.win.winrm.request.DeleteShellRequest;
import hudson.plugins.ec2.win.winrm.request.ExecuteCommandRequest;
import hudson.plugins.ec2.win.winrm.request.GetOutputRequest;
import hudson.plugins.ec2.win.winrm.request.OpenShellRequest;
import hudson.plugins.ec2.win.winrm.request.SendInputRequest;
import hudson.plugins.ec2.win.winrm.request.SignalRequest;
import java.net.URL;

public class RequestFactory {
    private final URL url;
    private String timeout = "PT60S";
    private int envelopSize = 153600;
    private String locale = "en-US";

    public RequestFactory(URL url) {
        this.url = url;
    }

    public OpenShellRequest newOpenShellRequest() {
        OpenShellRequest r = new OpenShellRequest(this.url);
        this.setDefaults(r);
        return r;
    }

    public ExecuteCommandRequest newExecuteCommandRequest(String shellId, String command) {
        ExecuteCommandRequest r = new ExecuteCommandRequest(this.url, shellId, command);
        this.setDefaults(r);
        return r;
    }

    public DeleteShellRequest newDeleteShellRequest(String shellId) {
        DeleteShellRequest r = new DeleteShellRequest(this.url, shellId);
        this.setDefaults(r);
        return r;
    }

    public SignalRequest newSignalRequest(String shellId, String commandId) {
        SignalRequest r = new SignalRequest(this.url, shellId, commandId);
        this.setDefaults(r);
        return r;
    }

    public SendInputRequest newSendInputRequest(byte[] input, String shellId, String commandId) {
        SendInputRequest r = new SendInputRequest(this.url, input, shellId, commandId);
        this.setDefaults(r);
        return r;
    }

    public GetOutputRequest newGetOutputRequest(String shellId, String commandId) {
        GetOutputRequest r = new GetOutputRequest(this.url, shellId, commandId);
        this.setDefaults(r);
        return r;
    }

    private void setDefaults(AbstractWinRMRequest r) {
        r.setTimeout(this.timeout);
        r.setLocale(this.locale);
        r.setEnvelopSize(this.envelopSize);
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public int getEnvelopSize() {
        return this.envelopSize;
    }

    public void setEnvelopSize(int envelopSize) {
        this.envelopSize = envelopSize;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }
}

