/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.Tag;
import hudson.remoting.Channel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.WriteAbortedException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.AbstractGitAPIImpl;
import org.jenkinsci.plugins.gitclient.GitClient;

abstract class LegacyCompatibleGitAPIImpl
extends AbstractGitAPIImpl
implements IGitAPI {
    protected final File workspace;

    @Override
    public boolean isBareRepository() throws GitException, InterruptedException {
        return this.isBareRepository("");
    }

    protected LegacyCompatibleGitAPIImpl(File workspace) {
        this.workspace = workspace;
    }

    @Override
    @Deprecated
    public boolean hasGitModules(String treeIsh) throws GitException {
        try {
            return new File(this.workspace, ".gitmodules").exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    @Deprecated
    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        this.submoduleInit();
        this.submoduleSync();
        this.fixSubmoduleUrls(remote, listener);
    }

    @Override
    @Deprecated
    public void fetch(String repository, String refspec) throws GitException, InterruptedException {
        this.fetch(repository, new RefSpec(refspec));
    }

    @Override
    @Deprecated
    public void fetch(RemoteConfig remoteRepository) throws InterruptedException {
        this.fetch((URIish)remoteRepository.getURIs().get(0), remoteRepository.getFetchRefSpecs());
    }

    @Override
    @Deprecated
    public void fetch() throws GitException, InterruptedException {
        this.fetch((String)null, (RefSpec)null);
    }

    @Override
    @Deprecated
    public void reset() throws GitException, InterruptedException {
        this.reset(false);
    }

    @Override
    @Deprecated
    public void push(URIish url, String refspec) throws GitException, InterruptedException {
        this.push().ref(refspec).to(url).execute();
    }

    @Override
    @Deprecated
    public void push(String remoteName, String refspec) throws GitException, InterruptedException {
        String url = this.getRemoteUrl(remoteName);
        if (url == null) {
            throw new GitException("bad remote name, URL not set in working copy");
        }
        try {
            this.push(new URIish(url), refspec);
        }
        catch (URISyntaxException e) {
            throw new GitException("bad repository URL", e);
        }
    }

    @Override
    @Deprecated
    public void clone(RemoteConfig source) throws GitException, InterruptedException {
        this.clone(source, false);
    }

    @Override
    @Deprecated
    public void clone(RemoteConfig rc, boolean useShallowClone) throws GitException, InterruptedException {
        String source = ((URIish)rc.getURIs().get(0)).toPrivateString();
        this.clone(source, rc.getName(), useShallowClone, null);
    }

    @Override
    @Deprecated
    public List<ObjectId> revListBranch(String branchId) throws GitException, InterruptedException {
        return this.revList(branchId);
    }

    @Override
    @Deprecated
    public List<String> showRevision(Revision r) throws GitException, InterruptedException {
        return this.showRevision(null, r.getSha1());
    }

    @Override
    @Deprecated
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Java 11 spotbugs error")
    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException {
        try (Repository db = this.getRepository();){
            ObjectId commit = db.resolve(revName);
            ArrayList<Tag> ret = new ArrayList<Tag>();
            for (Map.Entry tag : db.getTags().entrySet()) {
                Ref value = (Ref)tag.getValue();
                if (value == null) continue;
                ObjectId tagId = value.getObjectId();
                if (commit == null || !commit.equals((AnyObjectId)tagId)) continue;
                ret.add(new Tag((String)tag.getKey(), tagId));
            }
            ArrayList<Tag> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    public final List<IndexEntry> lsTree(String treeIsh) throws GitException, InterruptedException {
        return this.lsTree(treeIsh, false);
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        Channel currentChannel = Channel.current();
        if (currentChannel == null) {
            throw new WriteAbortedException("No current channel", new NullPointerException());
        }
        return this.remoteProxyFor((GitClient)currentChannel.export(IGitAPI.class, (Object)this));
    }

    @Override
    public boolean hasGitModules() throws GitException {
        try {
            File dotGit = new File(this.workspace, ".gitmodules");
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .gitmodules. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .gitmodules", e);
        }
    }

    @Override
    public List<String> showRevision(ObjectId r) throws GitException, InterruptedException {
        return this.showRevision(null, r);
    }

    protected String extractBranchNameFromBranchSpec(String branchSpec) {
        String[] branchExploded = branchSpec.split("/");
        String branch = branchSpec.startsWith("remotes/") ? "refs/heads/" + StringUtils.join((Object[])Arrays.copyOfRange(branchExploded, 2, branchExploded.length), (String)"/") : (branchSpec.startsWith("refs/remotes/") ? "refs/heads/" + StringUtils.join((Object[])Arrays.copyOfRange(branchExploded, 3, branchExploded.length), (String)"/") : (branchSpec.startsWith("refs/heads/") ? branchSpec : (branchSpec.startsWith("refs/tags/") ? branchSpec : branchExploded[branchExploded.length - 1])));
        return branch;
    }
}

