/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.IGitAPI;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.plugins.git.Tag;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.RemoteWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.security.MasterToSlaveCallable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.GitCommand;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RebaseCommand;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;

class RemoteGitImpl
implements GitClient,
IGitAPI,
Serializable {
    private final GitClient proxy;
    private transient Channel channel;
    private static final long serialVersionUID = 1L;

    RemoteGitImpl(GitClient proxy) {
        this.proxy = proxy;
    }

    private IGitAPI getGitAPI() {
        return (IGitAPI)this.proxy;
    }

    protected Object readResolve() {
        this.channel = Channel.current();
        return this;
    }

    private Object writeReplace() {
        if (this.channel != null) {
            return this.proxy;
        }
        return this;
    }

    private <T extends GitCommand> T command(Class<T> type) {
        return (T)((GitCommand)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new CommandInvocationHandler(type, this))));
    }

    private OutputStream wrap(OutputStream os) {
        return new RemoteOutputStream(os);
    }

    @Override
    @NonNull
    public Repository getRepository() throws GitException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearCredentials() {
        this.proxy.clearCredentials();
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.proxy.addCredentials(url, (StandardCredentials)CredentialsProvider.snapshot(StandardCredentials.class, (Credentials)credentials));
    }

    @Override
    public void setCredentials(StandardUsernameCredentials cred) {
        this.proxy.setCredentials((StandardUsernameCredentials)CredentialsProvider.snapshot(StandardUsernameCredentials.class, (Credentials)cred));
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.proxy.addDefaultCredentials((StandardCredentials)CredentialsProvider.snapshot(StandardCredentials.class, (Credentials)credentials));
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.proxy.setAuthor(name, email);
    }

    @Override
    public void setAuthor(PersonIdent p) throws GitException {
        this.proxy.setAuthor(p);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.proxy.setCommitter(name, email);
    }

    @Override
    public void setCommitter(PersonIdent p) throws GitException {
        this.proxy.setCommitter(p);
    }

    @Override
    public <T> T withRepository(RepositoryCallback<T> callable) throws IOException, InterruptedException {
        return this.proxy.withRepository(callable);
    }

    @Override
    public FilePath getWorkTree() {
        return this.proxy.getWorkTree();
    }

    @Override
    public void init() throws GitException, InterruptedException {
        this.proxy.init();
    }

    @Override
    public void add(String filePattern) throws GitException, InterruptedException {
        this.proxy.add(filePattern);
    }

    @Override
    public void commit(String message) throws GitException, InterruptedException {
        this.proxy.commit(message);
    }

    @Override
    public void commit(String message, PersonIdent author, PersonIdent committer) throws GitException, InterruptedException {
        this.proxy.setAuthor(author);
        this.proxy.setCommitter(committer);
        this.proxy.commit(message);
    }

    @Override
    public boolean hasGitRepo() throws GitException, InterruptedException {
        return this.proxy.hasGitRepo();
    }

    @Override
    public boolean hasGitRepo(boolean checkParentDirectories) throws GitException, InterruptedException {
        return this.proxy.hasGitRepo(checkParentDirectories);
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException, InterruptedException {
        return this.proxy.isCommitInRepo(commit);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException, InterruptedException {
        return this.proxy.getRemoteUrl(name);
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.proxy.setRemoteUrl(name, url);
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException, InterruptedException {
        this.proxy.addRemoteUrl(name, url);
    }

    @Override
    public void checkout(String ref) throws GitException, InterruptedException {
        this.proxy.checkout(ref);
    }

    @Override
    public void checkout(String ref, String branch) throws GitException, InterruptedException {
        this.proxy.checkout(ref, branch);
    }

    @Override
    public CheckoutCommand checkout() {
        return this.command(CheckoutCommand.class);
    }

    @Override
    public void checkoutBranch(String branch, String ref) throws GitException, InterruptedException {
        this.proxy.checkoutBranch(branch, ref);
    }

    @Override
    public ObjectId mergeBase(ObjectId sha1, ObjectId sha12) throws InterruptedException {
        return this.getGitAPI().mergeBase(sha1, sha12);
    }

    @Override
    public String getAllLogEntries(String branch) throws InterruptedException {
        return this.getGitAPI().getAllLogEntries(branch);
    }

    @Override
    public List<String> showRevision(Revision r) throws GitException, InterruptedException {
        return this.getGitAPI().showRevision(r);
    }

    @Override
    public void clone(String url, String origin, boolean useShallowClone, String reference) throws GitException, InterruptedException {
        this.proxy.clone(url, origin, useShallowClone, reference);
    }

    @Override
    public CloneCommand clone_() {
        return this.command(CloneCommand.class);
    }

    @Override
    public MergeCommand merge() {
        return this.command(MergeCommand.class);
    }

    @Override
    public RebaseCommand rebase() {
        return this.command(RebaseCommand.class);
    }

    @Override
    public InitCommand init_() {
        return this.command(InitCommand.class);
    }

    @Override
    public FetchCommand fetch_() {
        return this.command(FetchCommand.class);
    }

    @Override
    public PushCommand push() {
        return this.command(PushCommand.class);
    }

    @Override
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.proxy.fetch(url, refspecs);
    }

    @Override
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException, InterruptedException {
        this.proxy.fetch(remoteName, refspec);
    }

    @Override
    public void fetch(String remoteName, RefSpec refspec) throws GitException, InterruptedException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    @Override
    public void push(String remoteName, String refspec) throws GitException, InterruptedException {
        this.proxy.push(remoteName, refspec);
    }

    @Override
    public void push(URIish url, String refspec) throws GitException, InterruptedException {
        this.proxy.push(url, refspec);
    }

    @Override
    public void merge(ObjectId rev) throws GitException, InterruptedException {
        this.proxy.merge(rev);
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException, InterruptedException {
        this.proxy.prune(repository);
    }

    @Override
    public void clean(boolean cleanSubmodule) throws GitException, InterruptedException {
        this.proxy.clean(cleanSubmodule);
    }

    @Override
    public void clean() throws GitException, InterruptedException {
        this.proxy.clean();
    }

    @Override
    public void branch(String name) throws GitException, InterruptedException {
        this.proxy.branch(name);
    }

    @Override
    public void deleteBranch(String name) throws GitException, InterruptedException {
        this.proxy.deleteBranch(name);
    }

    @Override
    public Set<Branch> getBranches() throws GitException, InterruptedException {
        return this.proxy.getBranches();
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException, InterruptedException {
        return this.proxy.getRemoteBranches();
    }

    @Override
    public void tag(String tagName, String comment) throws GitException, InterruptedException {
        this.proxy.tag(tagName, comment);
    }

    @Override
    public boolean tagExists(String tagName) throws GitException, InterruptedException {
        return this.proxy.tagExists(tagName);
    }

    @Override
    public String getTagMessage(String tagName) throws GitException, InterruptedException {
        return this.proxy.getTagMessage(tagName);
    }

    @Override
    public void deleteTag(String tagName) throws GitException, InterruptedException {
        this.proxy.deleteTag(tagName);
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException, InterruptedException {
        return this.proxy.getTagNames(tagPattern);
    }

    @Override
    public void ref(String refName) throws GitException, InterruptedException {
        this.proxy.ref(refName);
    }

    @Override
    public boolean refExists(String refName) throws GitException, InterruptedException {
        return this.proxy.refExists(refName);
    }

    @Override
    public void deleteRef(String refName) throws GitException, InterruptedException {
        this.proxy.deleteRef(refName);
    }

    @Override
    public Set<String> getRefNames(String refPrefix) throws GitException, InterruptedException {
        return this.proxy.getRefNames(refPrefix);
    }

    @Override
    public Set<String> getRemoteTagNames(String tagPattern) throws GitException, InterruptedException {
        return this.proxy.getTagNames(tagPattern);
    }

    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        return this.proxy.getHeadRev(url);
    }

    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branch) throws GitException, InterruptedException {
        return this.proxy.getHeadRev(remoteRepoUrl, branch);
    }

    @Override
    public Map<String, ObjectId> getRemoteReferences(String remoteRepoUrl, String pattern, boolean headsOnly, boolean tagsOnly) throws GitException, InterruptedException {
        return this.proxy.getRemoteReferences(remoteRepoUrl, pattern, headsOnly, tagsOnly);
    }

    @Override
    public Map<String, String> getRemoteSymbolicReferences(String remoteRepoUrl, String pattern) throws GitException, InterruptedException {
        return this.proxy.getRemoteSymbolicReferences(remoteRepoUrl, pattern);
    }

    @Override
    public ObjectId revParse(String revName) throws GitException, InterruptedException {
        return this.proxy.revParse(revName);
    }

    @Override
    public RevListCommand revList_() {
        return this.proxy.revList_();
    }

    @Override
    public List<ObjectId> revListAll() throws GitException, InterruptedException {
        return this.proxy.revListAll();
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException, InterruptedException {
        return this.proxy.revList(ref);
    }

    @Override
    public GitClient subGit(String subdir) {
        return this.proxy.subGit(subdir);
    }

    @Override
    public boolean hasGitModules() throws GitException, InterruptedException {
        return this.proxy.hasGitModules();
    }

    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException, InterruptedException {
        return this.proxy.getSubmodules(treeIsh);
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException, InterruptedException {
        this.proxy.addSubmodule(remoteURL, subdir);
    }

    @Override
    public void submoduleUpdate(boolean recursive) throws GitException, InterruptedException {
        this.proxy.submoduleUpdate(recursive);
    }

    @Override
    public void submoduleUpdate(boolean recursive, String ref) throws GitException, InterruptedException {
        this.proxy.submoduleUpdate(recursive, ref);
    }

    @Override
    public void submoduleUpdate(boolean recursive, boolean remoteTracking) throws GitException, InterruptedException {
        this.proxy.submoduleUpdate(recursive, remoteTracking);
    }

    @Override
    public void submoduleUpdate(boolean recursive, boolean remoteTracking, String reference) throws GitException, InterruptedException {
        this.proxy.submoduleUpdate(recursive, remoteTracking, reference);
    }

    @Override
    public SubmoduleUpdateCommand submoduleUpdate() {
        return this.command(SubmoduleUpdateCommand.class);
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException, InterruptedException {
        this.proxy.submoduleClean(recursive);
    }

    @Override
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException, InterruptedException {
        this.proxy.setupSubmoduleUrls(rev, listener);
    }

    @Override
    public void changelog(String revFrom, String revTo, OutputStream os) throws GitException, InterruptedException {
        this.proxy.changelog(revFrom, revTo, this.wrap(os));
    }

    @Override
    public void changelog(String revFrom, String revTo, Writer os) throws GitException, InterruptedException {
        this.proxy.changelog(revFrom, revTo, os);
    }

    @Override
    public ChangelogCommand changelog() {
        return this.command(ChangelogCommand.class);
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException, InterruptedException {
        this.proxy.appendNote(note, namespace);
    }

    @Override
    public void addNote(String note, String namespace) throws GitException, InterruptedException {
        this.proxy.addNote(note, namespace);
    }

    @Override
    public List<String> showRevision(ObjectId r) throws GitException, InterruptedException {
        return this.proxy.showRevision(r);
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException, InterruptedException {
        return this.proxy.showRevision(from, to);
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to, Boolean useRawOutput) throws GitException, InterruptedException {
        return this.proxy.showRevision(from, to, useRawOutput);
    }

    @Override
    public boolean hasGitModules(String treeIsh) throws GitException, InterruptedException {
        return this.getGitAPI().hasGitModules(treeIsh);
    }

    @Override
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        return this.getGitAPI().getRemoteUrl(name, GIT_DIR);
    }

    @Override
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        this.getGitAPI().setRemoteUrl(name, url, GIT_DIR);
    }

    @Override
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        return this.getGitAPI().getDefaultRemote(_default_);
    }

    @Override
    public boolean isBareRepository() throws GitException, InterruptedException {
        return this.getGitAPI().isBareRepository();
    }

    @Override
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        return this.getGitAPI().isBareRepository(GIT_DIR);
    }

    @Override
    public void submoduleInit() throws GitException, InterruptedException {
        this.getGitAPI().submoduleInit();
    }

    @Override
    public void submoduleSync() throws GitException, InterruptedException {
        this.getGitAPI().submoduleSync();
    }

    @Override
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        return this.getGitAPI().getSubmoduleUrl(name);
    }

    @Override
    public void setSubmoduleUrl(String name, String url) throws GitException, InterruptedException {
        this.getGitAPI().setSubmoduleUrl(name, url);
    }

    @Override
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        this.getGitAPI().fixSubmoduleUrls(remote, listener);
    }

    @Override
    public void setupSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        this.getGitAPI().setupSubmoduleUrls(remote, listener);
    }

    @Override
    public void fetch(String repository, String refspec) throws GitException, InterruptedException {
        this.getGitAPI().fetch(repository, refspec);
    }

    @Override
    public void fetch(RemoteConfig remoteRepository) throws InterruptedException {
        this.getGitAPI().fetch(remoteRepository);
    }

    @Override
    public void fetch() throws GitException, InterruptedException {
        this.getGitAPI().fetch();
    }

    @Override
    public void reset(boolean hard) throws GitException, InterruptedException {
        this.getGitAPI().reset(hard);
    }

    @Override
    public void reset() throws GitException, InterruptedException {
        this.getGitAPI().reset();
    }

    @Override
    public void push(RemoteConfig repository, String revspec) throws GitException, InterruptedException {
        this.getGitAPI().push(repository, revspec);
    }

    @Override
    public void merge(String revSpec) throws GitException, InterruptedException {
        this.getGitAPI().merge(revSpec);
    }

    @Override
    public void clone(RemoteConfig source) throws GitException, InterruptedException {
        this.getGitAPI().clone(source);
    }

    @Override
    public void clone(RemoteConfig rc, boolean useShallowClone) throws GitException, InterruptedException {
        this.getGitAPI().clone(rc, useShallowClone);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        return this.getGitAPI().getBranchesContaining(revspec);
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh) throws GitException, InterruptedException {
        return this.getGitAPI().lsTree(treeIsh);
    }

    @Override
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        return this.getGitAPI().lsTree(treeIsh, recursive);
    }

    @Override
    public List<ObjectId> revListBranch(String branchId) throws GitException, InterruptedException {
        return this.getGitAPI().revListBranch(branchId);
    }

    @Override
    public String describe(String commitIsh) throws GitException, InterruptedException {
        return this.getGitAPI().describe(commitIsh);
    }

    @Override
    public List<Tag> getTagsOnCommit(String revName) throws GitException, IOException, InterruptedException {
        return this.getGitAPI().getTagsOnCommit(revName);
    }

    @Override
    public void setProxy(ProxyConfiguration proxyConfiguration) {
        this.proxy.setProxy(proxyConfiguration);
    }

    @Override
    public List<Branch> getBranchesContaining(String revspec, boolean allBranches) throws GitException, InterruptedException {
        return this.getGitAPI().getBranchesContaining(revspec, allBranches);
    }

    @Override
    public Set<GitObject> getTags() throws GitException, InterruptedException {
        return this.proxy.getTags();
    }

    @Override
    public boolean maintenance(String task) {
        return false;
    }

    @Override
    public void config(GitClient.ConfigLevel configLevel, String key, String value) throws GitException, InterruptedException {
        this.proxy.config(configLevel, key, value);
    }

    private static class CommandInvocationHandler
    implements InvocationHandler,
    GitCommand,
    Serializable {
        private final Class<? extends GitCommand> command;
        private final List<Invocation> invocations = new ArrayList<Invocation>();
        private final transient Channel channel;
        private final GitClient proxy;
        private static final long serialVersionUID = 1L;

        private CommandInvocationHandler(Class<? extends GitCommand> command, RemoteGitImpl owner) {
            this.command = command;
            this.channel = owner.channel;
            this.proxy = owner.proxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> decl = method.getDeclaringClass();
            if (args == null) {
                args = new Object[]{};
            }
            if (GitCommand.class == decl || Object.class == decl) {
                try {
                    return method.invoke((Object)this, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            if (GitCommand.class.isAssignableFrom(decl)) {
                this.invocations.add(new Invocation(method, args));
                return proxy;
            }
            throw new IllegalStateException("Unexpected invocation: " + method);
        }

        @Override
        public void execute() throws GitException, InterruptedException {
            try {
                this.channel.call((Callable)new GitCommandMasterToSlaveCallable());
            }
            catch (IOException e) {
                throw new GitException(e);
            }
        }

        private class GitCommandMasterToSlaveCallable
        extends MasterToSlaveCallable<Void, GitException> {
            private GitCommandMasterToSlaveCallable() {
            }

            public Void call() throws GitException {
                try {
                    GitCommand cmd = this.createCommand();
                    for (Invocation inv : CommandInvocationHandler.this.invocations) {
                        inv.replay(cmd);
                    }
                    cmd.execute();
                    return null;
                }
                catch (IllegalAccessException | InterruptedException | InvocationTargetException e) {
                    throw new GitException(e);
                }
            }

            private GitCommand createCommand() throws InvocationTargetException, IllegalAccessException {
                for (Method m : GitClient.class.getMethods()) {
                    if (m.getReturnType() != CommandInvocationHandler.this.command || m.getParameterTypes().length != 0) continue;
                    return CommandInvocationHandler.this.command.cast(m.invoke((Object)CommandInvocationHandler.this.proxy, new Object[0]));
                }
                throw new IllegalStateException("Can't find the factory method for " + CommandInvocationHandler.this.command);
            }
        }
    }

    static class Invocation
    implements Serializable {
        private final String methodName;
        private final String[] parameterTypes;
        private final Object[] args;
        private static final long serialVersionUID = 1L;

        Invocation(Method method, @NonNull Object[] args) {
            int i;
            this.methodName = method.getName();
            this.args = args;
            this.parameterTypes = new String[args.length];
            Class<?>[] paramTypes = method.getParameterTypes();
            for (i = 0; i < args.length; ++i) {
                this.parameterTypes[i] = paramTypes[i].getName();
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i] instanceof OutputStream) {
                    args[i] = new RemoteOutputStream((OutputStream)args[i]);
                }
                if (!(args[i] instanceof Writer)) continue;
                args[i] = new RemoteWriter((Writer)args[i]);
            }
        }

        public void replay(Object target) throws InvocationTargetException, IllegalAccessException {
            block0: for (Method m : target.getClass().getMethods()) {
                if (!m.getName().equals(this.methodName) || m.getParameterTypes().length != this.parameterTypes.length) continue;
                Class<?>[] t = m.getParameterTypes();
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    if (!t[i].getName().equals(this.parameterTypes[i])) continue block0;
                }
                m.invoke(target, this.args);
                return;
            }
            throw new IllegalStateException("Method not found: " + this.methodName + "(" + String.join((CharSequence)",", this.parameterTypes) + ")");
        }
    }
}

