/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.UserRemoteConfig;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.After;
import org.junit.Before;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public abstract class AbstractGitRepository {
    protected File testGitDir;
    protected GitClient testGitClient;
    private TemporaryDirectoryAllocator tempAllocator;

    @Before
    public void createGitRepository() throws IOException, InterruptedException {
        this.tempAllocator = new TemporaryDirectoryAllocator();
        this.testGitDir = this.tempAllocator.allocate();
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        this.testGitClient = Git.with((TaskListener)listener, (EnvVars)new EnvVars()).in(this.testGitDir).getClient();
        this.testGitClient.init();
    }

    @After
    public void removeGitRepository() throws IOException, InterruptedException {
        if (this.isWindows()) {
            System.gc();
        }
        this.tempAllocator.dispose();
    }

    protected void commitNewFile(String fileName) throws GitException, InterruptedException {
        File newFile = new File(this.testGitDir, fileName);
        assert (!newFile.exists());
        try (PrintWriter writer = new PrintWriter(newFile, "UTF-8");){
            writer.println("A file named " + fileName);
            writer.close();
            this.testGitClient.add(fileName);
            this.testGitClient.commit("Added a file named " + fileName);
        }
        catch (FileNotFoundException | UnsupportedEncodingException notFound) {
            throw new GitException((Throwable)notFound);
        }
    }

    protected List<UserRemoteConfig> remoteConfigs() throws IOException {
        ArrayList<UserRemoteConfig> list = new ArrayList<UserRemoteConfig>();
        list.add(new UserRemoteConfig(this.testGitDir.getAbsolutePath(), "origin", "", null));
        return list;
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

