/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitChangeSetList;
import java.io.File;
import java.io.FileWriter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class GitChangeLogParserTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Test
    public void testDuplicatesFiltered() throws Exception {
        GitChangeLogParser parser = new GitChangeLogParser(true);
        File log = this.tmpFolder.newFile();
        try (FileWriter writer = new FileWriter(log);){
            writer.write("commit 123abc456def\n");
            writer.write("    first message\n");
            writer.write("commit 123abc456def\n");
            writer.write("    second message");
        }
        GitChangeSetList list = parser.parse(null, null, log);
        Assert.assertNotNull((Object)list);
        Assert.assertNotNull((Object)list.getLogs());
        Assert.assertEquals((long)1L, (long)list.getLogs().size());
        GitChangeSet first = (GitChangeSet)list.getLogs().get(0);
        Assert.assertNotNull((Object)first);
        Assert.assertEquals((Object)"123abc456def", (Object)first.getId());
        Assert.assertEquals((Object)"first message", (Object)first.getMsg());
        Assert.assertTrue((String)("Temp file delete failed for " + log), (boolean)log.delete());
    }
}

