/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.TestGitRepo;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.Trigger;
import hudson.util.StreamTaskListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.multiplescms.MultiSCM;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.CaptureEnvironmentBuilder;
import org.jvnet.hudson.test.JenkinsRule;
import org.mockito.Mockito;

public class GitStatusMultipleSCMTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private GitStatus gitStatus;
    private TestGitRepo repo0;
    private TestGitRepo repo1;
    private FreeStyleProject testProject;

    @Before
    public void setUp() throws Exception {
        this.gitStatus = new GitStatus();
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        this.repo0 = new TestGitRepo("repo0", this.tmp.newFolder(), (TaskListener)listener);
        this.repo1 = new TestGitRepo("repo1", this.tmp.newFolder(), (TaskListener)listener);
        this.testProject = this.r.createFreeStyleProject();
    }

    @Test
    public void commitNotificationIsPropagatedOnlyToSourceRepository() throws Exception {
        this.setupProject("master", false);
        this.repo0.commit("repo0", this.repo1.johnDoe, "repo0 commit 1");
        String repo1sha1 = this.repo1.commit("repo1", this.repo1.janeDoe, "repo1 commit 1");
        this.gitStatus.doNotifyCommit(this.requestWithoutParameters(), this.repo1.remoteConfigs().get(0).getUrl(), null, repo1sha1);
        Assert.assertTrue((String)"expected a build start on notify", (boolean)this.r.isSomethingHappening());
        this.r.waitUntilNoActivity();
        List projects = this.r.getInstance().getAllItems(AbstractProject.class);
        Assert.assertThat((String)"should contain previously created project", (Object)projects.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        for (AbstractProject project : projects) {
            AbstractBuild lastBuild = project.getLastBuild();
            Assert.assertNotNull((String)"one build should've been built after notification", (Object)lastBuild);
            this.r.assertBuildStatusSuccess((Run)lastBuild);
        }
    }

    private HttpServletRequest requestWithoutParameters() {
        return (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    }

    private SCMTrigger setupProject(String branchString, boolean ignoreNotifyCommit) throws Exception {
        SCMTrigger trigger = new SCMTrigger("", ignoreNotifyCommit);
        this.setupProject(branchString, trigger);
        return trigger;
    }

    private void setupProject(String branchString, SCMTrigger trigger) throws Exception {
        List<BranchSpec> branch = Collections.singletonList(new BranchSpec(branchString));
        GitSCM repo0Scm = new GitSCM(this.repo0.remoteConfigs(), branch, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        GitSCM repo1Scm = new GitSCM(this.repo1.remoteConfigs(), branch, Boolean.valueOf(false), Collections.emptyList(), null, null, Collections.emptyList());
        ArrayList<GitSCM> testScms = new ArrayList<GitSCM>();
        testScms.add(repo0Scm);
        testScms.add(repo1Scm);
        MultiSCM scm = new MultiSCM(testScms);
        this.testProject.setScm((SCM)scm);
        this.testProject.getBuildersList().add((Object)new CaptureEnvironmentBuilder());
        if (trigger != null) {
            this.testProject.addTrigger((Trigger)trigger);
        }
    }
}

