/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import hudson.model.TaskListener;
import hudson.util.StreamTaskListener;
import java.util.UUID;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.GitSampleRepoRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;

public class AbstractGitSCMSourceTest {
    @Rule
    public JenkinsRule r = new JenkinsRule();
    @Rule
    public GitSampleRepoRule sampleRepo = new GitSampleRepoRule();

    @Test
    public void retrieveHeads() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("file", "modified");
        this.sampleRepo.git("commit", "--all", "--message=dev");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2");
        this.sampleRepo.write("file", "modified again");
        this.sampleRepo.git("commit", "--all", "--message=dev2");
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
    }

    @Test
    public void pruneRemovesDeletedBranches() throws Exception {
        this.sampleRepo.init();
        this.sampleRepo.write("master-file", "master-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "master-file");
        this.sampleRepo.git("commit", "--message=master-branch-commit-message");
        this.sampleRepo.git("checkout", "-b", "dev");
        this.sampleRepo.write("dev-file", "dev-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev-file");
        this.sampleRepo.git("commit", "--message=dev-branch-commit-message");
        GitSCMSource source = new GitSCMSource(null, this.sampleRepo.toString(), "", "*", "", true);
        StreamTaskListener listener = StreamTaskListener.fromStderr();
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("checkout", "-b", "dev2", "master");
        this.sampleRepo.write("dev2-file", "dev2-content-" + UUID.randomUUID().toString());
        this.sampleRepo.git("add", "dev2-file");
        this.sampleRepo.git("commit", "--message=dev2-branch-commit-message");
        Assert.assertEquals((Object)"[SCMHead{'dev'}, SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
        this.sampleRepo.git("branch", "-D", "dev");
        Assert.assertEquals((Object)"[SCMHead{'dev2'}, SCMHead{'master'}]", (Object)source.fetch((TaskListener)listener).toString());
    }
}

