/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.git;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.TaskListener;
import java.util.Collections;
import java.util.List;
import jenkins.plugins.git.GitSCMSourceContext;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMSourceRequest;
import org.eclipse.jgit.transport.RefSpec;

public class GitSCMSourceRequest
extends SCMSourceRequest {
    private final List<RefSpec> refSpecs;
    private final String remoteName;
    private final String gitTool;

    public GitSCMSourceRequest(@NonNull SCMSource source, @NonNull GitSCMSourceContext<?, ?> context, TaskListener listener) {
        super(source, context, listener);
        this.remoteName = context.remoteName();
        this.gitTool = context.gitTool();
        this.refSpecs = Collections.unmodifiableList(context.asRefSpecs());
    }

    @CheckForNull
    public final String gitTool() {
        return this.gitTool;
    }

    @NonNull
    public final String remoteName() {
        return this.remoteName;
    }

    @NonNull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Low risk")
    public final List<RefSpec> refSpecs() {
        return this.refSpecs;
    }
}

