/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.FisheyeGitRepositoryBrowser;
import hudson.plugins.git.browser.GitChangeSetSample;
import hudson.scm.EditType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FisheyeGitRepositoryBrowserTest {
    private static final String projectName = "fisheyeProjectName";
    private final String repoUrl;
    private final String repoUrlNoTrailingSlash;
    private final boolean useAuthorName;
    private final GitChangeSetSample sample;

    public FisheyeGitRepositoryBrowserTest(String useAuthorName, String repoUrl) {
        this.useAuthorName = Boolean.valueOf(useAuthorName);
        this.repoUrl = repoUrl;
        this.repoUrlNoTrailingSlash = this.repoUrl.endsWith("/") ? repoUrl.substring(0, repoUrl.length() - 1) : repoUrl;
        this.sample = new GitChangeSetSample(this.useAuthorName);
    }

    @Parameterized.Parameters(name="{0}-{1}")
    public static Collection permuteAuthorNameAndRepoUrl() {
        String[] allowed;
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        String fisheyeUrl = "http://fisheye.example.com/site/browse/fisheyeProjectName";
        String[] allowedUrls = new String[]{fisheyeUrl, fisheyeUrl + "/"};
        for (String authorName : allowed = new String[]{"true", "false"}) {
            for (String repoUrl : allowedUrls) {
                Object[] combination = new Object[]{authorName, repoUrl};
                values.add(combination);
            }
        }
        return values;
    }

    @Test
    public void testGetChangeSetLink() throws Exception {
        URL result = new FisheyeGitRepositoryBrowser(this.repoUrl).getChangeSetLink(this.sample.changeSet);
        Assert.assertEquals((Object)new URL(this.repoUrlNoTrailingSlash.replace("browse", "changelog") + "?cs=" + this.sample.id), (Object)result);
    }

    @Test
    public void testGetDiffLink() throws Exception {
        FisheyeGitRepositoryBrowser fisheye = new FisheyeGitRepositoryBrowser(this.repoUrl);
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            URL diffLink = fisheye.getDiffLink(path);
            EditType editType = path.getEditType();
            String slash = this.repoUrl.endsWith("/") ? "" : "/";
            URL expectedDiffLink = new URL(this.repoUrl + slash + path.getPath() + "?r1=" + this.sample.parent + "&r2=" + this.sample.id);
            if (editType == EditType.DELETE || editType == EditType.ADD) {
                expectedDiffLink = null;
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedDiffLink, (Object)diffLink);
        }
    }

    @Test
    public void testGetFileLink() throws Exception {
        FisheyeGitRepositoryBrowser fisheye = new FisheyeGitRepositoryBrowser(this.repoUrl);
        for (GitChangeSet.Path path : this.sample.changeSet.getPaths()) {
            String slash;
            URL fileLink = fisheye.getFileLink(path);
            EditType editType = path.getEditType();
            URL expectedFileLink = null;
            String string = slash = this.repoUrl.endsWith("/") ? "" : "/";
            if (editType == EditType.ADD || editType == EditType.EDIT) {
                expectedFileLink = new URL(this.repoUrl + slash + path.getPath());
            } else if (editType == EditType.DELETE) {
                expectedFileLink = new URL(this.repoUrl + slash + path.getPath());
            } else {
                Assert.fail((String)("Unexpected edit type " + editType.getName()));
            }
            String msg = "Wrong link for path: " + path.getPath() + ", edit type: " + editType.getName();
            Assert.assertEquals((String)msg, (Object)expectedFileLink, (Object)fileLink);
        }
    }
}

