/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.RedmineWeb;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class RedmineWebTest {
    private static final String REDMINE_URL = "https://SERVER/PATH/projects/PROJECT/repository";
    private final RedmineWeb redmineWeb = new RedmineWeb("https://SERVER/PATH/projects/PROJECT/repository");
    private final Random random = new Random();

    @Test
    public void testGetUrl() throws IOException {
        Assert.assertEquals((Object)String.valueOf(this.redmineWeb.getUrl()), (Object)"https://SERVER/PATH/projects/PROJECT/repository/");
    }

    @Test
    public void testGetUrlForRepoWithTrailingSlash() throws IOException {
        Assert.assertEquals((Object)String.valueOf(new RedmineWeb("https://SERVER/PATH/projects/PROJECT/repository/").getUrl()), (Object)"https://SERVER/PATH/projects/PROJECT/repository/");
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws Exception {
        URL changeSetLink = this.redmineWeb.getChangeSetLink(this.createChangeSet("rawchangelog"));
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/diff?rev=396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)changeSetLink.toString());
    }

    @Test
    public void testGetDiffLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path modified1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/revisions/396fc230a3db05c427737aa5c2eb7856ba72b05d/diff/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)this.redmineWeb.getDiffLink(modified1).toString());
        GitChangeSet.Path modified2 = pathMap.get("src/test/java/hudson/plugins/git/browser/GithubWebTest.java");
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/revisions/396fc230a3db05c427737aa5c2eb7856ba72b05d/diff/src/test/java/hudson/plugins/git/browser/GithubWebTest.java", (Object)this.redmineWeb.getDiffLink(modified2).toString());
        GitChangeSet.Path added = pathMap.get("src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file");
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/revisions/396fc230a3db05c427737aa5c2eb7856ba72b05d/entry/src/test/resources/hudson/plugins/git/browser/rawchangelog-with-deleted-file", (Object)this.redmineWeb.getDiffLink(added).toString());
    }

    @Test
    public void testGetFileLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        URL fileLink = this.redmineWeb.getFileLink(path);
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/revisions/396fc230a3db05c427737aa5c2eb7856ba72b05d/entry/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        GitChangeSet.Path path = pathMap.get("bar");
        URL fileLink = this.redmineWeb.getFileLink(path);
        Assert.assertEquals((Object)"https://SERVER/PATH/projects/PROJECT/repository/revisions/fc029da233f161c65eb06d0f1ed4f36ae81d1f4f/diff/bar", (Object)String.valueOf(fileLink));
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.random.nextBoolean() ? null : "jgit").getClient();
        GitChangeLogParser logParser = new GitChangeLogParser(gitClient, false);
        List changeSetList = logParser.parse(RedmineWebTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }
}

