/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.EnvVars;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeLogParser;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.RhodeCode;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Assert;
import org.junit.Test;

public class RhodeCodeTest {
    private static final String RHODECODE_URL = "https://SERVER/r/PROJECT";
    private final RhodeCode rhodecode = new RhodeCode("https://SERVER/r/PROJECT");
    private final Random random = new Random();

    @Test
    public void testGetUrl() throws IOException {
        Assert.assertEquals((Object)String.valueOf(this.rhodecode.getUrl()), (Object)"https://SERVER/r/PROJECT/");
    }

    @Test
    public void testGetUrlForRepoWithTrailingSlash() throws IOException {
        Assert.assertEquals((Object)String.valueOf(new RhodeCode("https://SERVER/r/PROJECT/").getUrl()), (Object)"https://SERVER/r/PROJECT/");
    }

    @Test
    public void testGetChangeSetLinkGitChangeSet() throws Exception {
        URL changeSetLink = this.rhodecode.getChangeSetLink(this.createChangeSet("rawchangelog"));
        Assert.assertEquals((Object)"https://SERVER/r/PROJECT/changeset/396fc230a3db05c427737aa5c2eb7856ba72b05d", (Object)changeSetLink.toString());
    }

    @Test
    public void testGetDiffLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path modified1 = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"https://SERVER/r/PROJECT/diff/src/main/java/hudson/plugins/git/browser/GithubWeb.java?diff2=f28f125f4cc3e5f6a32daee6a26f36f7b788b8ff&diff1=396fc230a3db05c427737aa5c2eb7856ba72b05d&diff=diff+to+revision", (Object)this.rhodecode.getDiffLink(modified1).toString());
        GitChangeSet.Path added = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        Assert.assertEquals((Object)"https://SERVER/r/PROJECT/diff/src/main/java/hudson/plugins/git/browser/GithubWeb.java?diff2=f28f125f4cc3e5f6a32daee6a26f36f7b788b8ff&diff1=396fc230a3db05c427737aa5c2eb7856ba72b05d&diff=diff+to+revision", (Object)this.rhodecode.getDiffLink(added).toString());
    }

    @Test
    public void testGetFileLinkPath() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog");
        GitChangeSet.Path path = pathMap.get("src/main/java/hudson/plugins/git/browser/GithubWeb.java");
        URL fileLink = this.rhodecode.getFileLink(path);
        Assert.assertEquals((Object)"https://SERVER/r/PROJECT/files/396fc230a3db05c427737aa5c2eb7856ba72b05d/src/main/java/hudson/plugins/git/browser/GithubWeb.java", (Object)String.valueOf(fileLink));
    }

    @Test
    public void testGetFileLinkPathForDeletedFile() throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = this.createPathMap("rawchangelog-with-deleted-file");
        GitChangeSet.Path path = pathMap.get("bar");
        URL fileLink = this.rhodecode.getFileLink(path);
        Assert.assertEquals((Object)"https://SERVER/r/PROJECT/files/b547aa10c3f06710c6fdfcdb2a9149c81662923b/bar", (Object)String.valueOf(fileLink));
    }

    private GitChangeSet createChangeSet(String rawchangelogpath) throws Exception {
        GitClient gitClient = Git.with((TaskListener)TaskListener.NULL, (EnvVars)new EnvVars()).in(new File(".")).using(this.random.nextBoolean() ? null : "jgit").getClient();
        GitChangeLogParser logParser = new GitChangeLogParser(gitClient, false);
        List changeSetList = logParser.parse(RhodeCodeTest.class.getResourceAsStream(rawchangelogpath));
        return (GitChangeSet)changeSetList.get(0);
    }

    private HashMap<String, GitChangeSet.Path> createPathMap(String changelog) throws Exception {
        HashMap<String, GitChangeSet.Path> pathMap = new HashMap<String, GitChangeSet.Path>();
        Collection changeSet = this.createChangeSet(changelog).getPaths();
        for (GitChangeSet.Path path : changeSet) {
            pathMap.put(path.getPath(), path);
        }
        return pathMap;
    }
}

