/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions.impl;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.impl.LogHandler;
import hudson.plugins.git.extensions.impl.SparseCheckoutPath;
import hudson.plugins.git.extensions.impl.SparseCheckoutPaths;
import hudson.util.LogTaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.junit.Before;
import org.junit.Test;

public class SparseCheckoutPathsTest {
    private final SparseCheckoutPaths emptySparseCheckoutPaths;
    private final List<SparseCheckoutPath> emptySparseCheckoutPathList = new ArrayList<SparseCheckoutPath>();
    private final SparseCheckoutPaths sparseCheckoutPaths;
    private final List<SparseCheckoutPath> sparseCheckoutPathList;
    private static final String SRC_DIR_NAME = "src";
    private static final SparseCheckoutPath SRC_SPARSE_CHECKOUT_PATH = new SparseCheckoutPath("src");
    private LogTaskListener listener;
    private LogHandler handler;
    private int logCount = 0;

    public SparseCheckoutPathsTest() {
        this.emptySparseCheckoutPaths = new SparseCheckoutPaths(this.emptySparseCheckoutPathList);
        this.sparseCheckoutPathList = new ArrayList<SparseCheckoutPath>();
        this.sparseCheckoutPathList.add(SRC_SPARSE_CHECKOUT_PATH);
        this.sparseCheckoutPaths = new SparseCheckoutPaths(this.sparseCheckoutPathList);
        this.listener = null;
        this.handler = null;
    }

    @Before
    public void createLogger() {
        Logger logger = Logger.getLogger(this.getClass().getPackage().getName() + "-" + this.logCount++);
        this.handler = new LogHandler();
        this.handler.setLevel(Level.ALL);
        logger.setUseParentHandlers(false);
        logger.addHandler(this.handler);
        logger.setLevel(Level.ALL);
        this.listener = new LogTaskListener(logger, Level.ALL);
    }

    @Test
    public void testGetSparseCheckoutPaths() {
        MatcherAssert.assertThat((Object)this.sparseCheckoutPaths.getSparseCheckoutPaths(), (Matcher)Matchers.hasItem((Object)SRC_SPARSE_CHECKOUT_PATH));
    }

    @Test
    public void testGetSparseCheckoutPathsEmpty() {
        MatcherAssert.assertThat((Object)this.emptySparseCheckoutPaths.getSparseCheckoutPaths(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testDecorateCloneCommand() throws Exception {
        GitSCM scm = null;
        Run build = null;
        GitClient git = null;
        CloneCommand cmd = null;
        this.sparseCheckoutPaths.decorateCloneCommand(scm, build, git, (TaskListener)this.listener, cmd);
        MatcherAssert.assertThat(this.handler.getMessages(), (Matcher)Matchers.hasItem((Object)"Using no checkout clone with sparse checkout."));
    }

    @Test
    public void testDecorateCloneCommandEmpty() throws Exception {
        GitSCM scm = null;
        Run build = null;
        GitClient git = null;
        CloneCommand cmd = null;
        this.emptySparseCheckoutPaths.decorateCloneCommand(scm, build, git, (TaskListener)this.listener, cmd);
        MatcherAssert.assertThat(this.handler.getMessages(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }

    @Test
    public void testDecorateCheckoutCommand() throws Exception {
        GitSCM scm = null;
        Run build = null;
        GitClient git = null;
        MyCheckoutCommand cmd = new MyCheckoutCommand();
        this.sparseCheckoutPaths.decorateCheckoutCommand(scm, build, git, (TaskListener)this.listener, (CheckoutCommand)cmd);
        MatcherAssert.assertThat(cmd.getSparsePathNames(), (Matcher)Matchers.hasItems((Object[])new String[]{SRC_DIR_NAME}));
    }

    @Test
    public void equalsContract() {
        EqualsVerifier.forClass(SparseCheckoutPaths.class).usingGetClass().verify();
    }

    @Test
    public void testHashCode() {
        SparseCheckoutPaths emptySparseCheckoutPathsCopy = new SparseCheckoutPaths(this.emptySparseCheckoutPathList);
        MatcherAssert.assertThat((Object)this.emptySparseCheckoutPaths.hashCode(), (Matcher)Matchers.is((Object)emptySparseCheckoutPathsCopy.hashCode()));
        MatcherAssert.assertThat((Object)this.emptySparseCheckoutPaths, (Matcher)Matchers.is((Object)emptySparseCheckoutPathsCopy));
    }

    @Test
    public void testToString() {
        MatcherAssert.assertThat((Object)this.emptySparseCheckoutPaths.toString(), (Matcher)Matchers.is((Object)"SparseCheckoutPaths{sparseCheckoutPaths=[]}"));
    }

    private class MyCheckoutCommand
    implements CheckoutCommand {
        private List<String> sparsePathNames;

        private MyCheckoutCommand() {
        }

        List<String> getSparsePathNames() {
            return this.sparsePathNames;
        }

        public CheckoutCommand ref(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CheckoutCommand branch(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CheckoutCommand deleteBranchIfExist(boolean bln) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CheckoutCommand sparseCheckoutPaths(List<String> list) {
            this.sparsePathNames = list;
            return this;
        }

        public CheckoutCommand timeout(Integer intgr) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CheckoutCommand lfsRemote(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public CheckoutCommand lfsCredentials(StandardCredentials sc) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void execute() throws GitException, InterruptedException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

