/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.git.Revision;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;

@SuppressFBWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="Known non-serializable field critical part of class")
public class CommitTimeComparator
implements Comparator<Revision> {
    private final RevWalk walk;

    public CommitTimeComparator(Repository r) {
        this.walk = new RevWalk(r);
    }

    @Override
    public int compare(Revision lhs, Revision rhs) {
        return this.compare(this.time(lhs), this.time(rhs));
    }

    private int time(Revision r) {
        try {
            return this.walk.parseCommit((AnyObjectId)r.getSha1()).getCommitTime();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse " + r.getSha1(), e);
        }
    }

    @Override
    private int compare(int lhs, int rhs) {
        return Integer.compare(lhs, rhs);
    }
}

