/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Run;
import hudson.util.HttpResponses;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import jenkins.model.RunAction2;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.owasp.encoder.Encode;

public class HtmlPublisherTarget
extends AbstractDescribableImpl<HtmlPublisherTarget> {
    private String reportName;
    private final String reportDir;
    private final String reportFiles;
    private final boolean alwaysLinkToLastBuild;
    private String reportTitles;
    private final boolean keepAll;
    private final boolean allowMissing;
    @Deprecated
    private transient String wrapperName;
    private static final String WRAPPER_NAME = "htmlpublisher-wrapper.html";
    public static final String INCLUDE_ALL_PATTERN = "**/*";
    private String includes;
    private Boolean escapeUnderscores;
    private Boolean useWrapperFileDirectly;
    private int numberOfWorkers = 0;

    @Deprecated
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll, boolean allowMissing) {
        this(reportName, reportDir, reportFiles, keepAll, false, allowMissing);
    }

    public String getReportTitles() {
        return this.reportTitles;
    }

    @DataBoundConstructor
    public HtmlPublisherTarget(String reportName, String reportDir, String reportFiles, boolean keepAll, boolean alwaysLinkToLastBuild, boolean allowMissing) {
        this.reportName = StringUtils.trim((String)reportName);
        this.reportDir = StringUtils.trim((String)reportDir);
        this.reportFiles = StringUtils.trim((String)reportFiles);
        this.keepAll = keepAll;
        this.alwaysLinkToLastBuild = alwaysLinkToLastBuild;
        this.allowMissing = allowMissing;
    }

    public String getReportName() {
        return this.reportName;
    }

    public String getReportDir() {
        return this.reportDir;
    }

    public String getReportFiles() {
        return this.reportFiles;
    }

    public boolean getAlwaysLinkToLastBuild() {
        return this.alwaysLinkToLastBuild;
    }

    public boolean getKeepAll() {
        return this.keepAll;
    }

    public boolean getAllowMissing() {
        return this.allowMissing;
    }

    public boolean getEscapeUnderscores() {
        if (this.escapeUnderscores == null) {
            return true;
        }
        return this.escapeUnderscores;
    }

    @DataBoundSetter
    public void setEscapeUnderscores(boolean escapeUnderscores) {
        this.escapeUnderscores = escapeUnderscores;
    }

    public Boolean getUseWrapperFileDirectly() {
        if (this.useWrapperFileDirectly == null) {
            return false;
        }
        return this.useWrapperFileDirectly;
    }

    @DataBoundSetter
    public void setUseWrapperFileDirectly(boolean useWrapperFileDirectly) {
        this.useWrapperFileDirectly = useWrapperFileDirectly;
    }

    public int getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    @DataBoundSetter
    public void setNumberOfWorkers(int numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }

    @DataBoundSetter
    public void setReportTitles(String reportTitles) {
        this.reportTitles = StringUtils.trim((String)reportTitles);
    }

    public void setReportName(String reportName) {
        this.reportName = StringUtils.trim((String)reportName);
    }

    public String getSanitizedName() {
        return HtmlPublisherTarget.sanitizeReportName(this.reportName, this.getEscapeUnderscores());
    }

    @Restricted(value={NoExternalUse.class})
    public static String sanitizeReportName(String reportName, boolean escapeUnderscores) {
        Pattern p = escapeUnderscores ? Pattern.compile("[^a-zA-Z0-9-]") : Pattern.compile("[^a-zA-Z0-9-_]");
        Matcher m = p.matcher(reportName);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String match = m.group();
            m.appendReplacement(sb, "_" + Hex.encodeHexString((byte[])match.getBytes(StandardCharsets.UTF_8)));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String getWrapperName() {
        return WRAPPER_NAME;
    }

    public FilePath getArchiveTarget(Run build) {
        return new FilePath(this.keepAll ? this.getBuildArchiveDir(build) : this.getProjectArchiveDir((AbstractItem)build.getParent()));
    }

    private File getProjectArchiveDir(AbstractItem project) {
        return this.getProjectArchiveDir(project, this.getSanitizedName());
    }

    private File getProjectArchiveDir(AbstractItem project, String dirName) {
        return new File(new File(project.getRootDir(), "htmlreports"), dirName);
    }

    private File getBuildArchiveDir(Run run) {
        return this.getBuildArchiveDir(run, this.getSanitizedName());
    }

    private File getBuildArchiveDir(Run run, String dirName) {
        return new File(new File(run.getRootDir(), "htmlreports"), dirName);
    }

    @Deprecated
    public void handleAction(Run<?, ?> build) {
        this.handleAction(build, null);
    }

    void handleAction(Run<?, ?> build, String checksum) {
        if (this.keepAll) {
            HTMLBuildAction a = new HTMLBuildAction(build, this);
            a.setWrapperChecksum(checksum);
            build.addAction((Action)a);
        } else {
            build.addAction((Action)new HTMLPublishedForProjectMarkerAction(build, this));
        }
    }

    public Action getProjectAction(AbstractItem item) {
        return new HTMLAction(item, this);
    }

    public String getIncludes() {
        if (Util.fixEmpty((String)this.includes) == null) {
            return INCLUDE_ALL_PATTERN;
        }
        return this.includes;
    }

    @DataBoundSetter
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    protected Object readResolve() {
        if (this.includes == null) {
            this.includes = INCLUDE_ALL_PATTERN;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.reportName != null ? this.reportName.hashCode() : 0);
        hash = 97 * hash + (this.reportDir != null ? this.reportDir.hashCode() : 0);
        hash = 97 * hash + (this.reportFiles != null ? this.reportFiles.hashCode() : 0);
        hash = 97 * hash + (this.alwaysLinkToLastBuild ? 1 : 0);
        hash = 97 * hash + (this.keepAll ? 1 : 0);
        hash = 97 * hash + (this.allowMissing ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HtmlPublisherTarget other = (HtmlPublisherTarget)((Object)obj);
        if (!Objects.equals(this.reportName, other.reportName)) {
            return false;
        }
        if (!Objects.equals(this.reportDir, other.reportDir)) {
            return false;
        }
        if (!Objects.equals(this.reportFiles, other.reportFiles)) {
            return false;
        }
        if (this.alwaysLinkToLastBuild != other.alwaysLinkToLastBuild) {
            return false;
        }
        if (this.keepAll != other.keepAll) {
            return false;
        }
        return this.allowMissing == other.allowMissing;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<HtmlPublisherTarget> {
        @NonNull
        public String getDisplayName() {
            return "";
        }
    }

    public class HTMLBuildAction
    extends BaseHTMLAction
    implements RunAction2 {
        private transient Run<?, ?> build;
        private String wrapperChecksum;

        public HTMLBuildAction(Run<?, ?> build, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.build = build;
        }

        @WithBridgeMethods(value={AbstractBuild.class}, castRequired=true)
        public final Run<?, ?> getOwner() {
            return this.build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " html3";
        }

        @Override
        public String getBackToName() {
            return Encode.forHtml((String)this.build.getDisplayName());
        }

        @Override
        public String getBackToUrl() {
            return this.build.getUrl();
        }

        @Override
        protected File dir() {
            File buildArchiveDir = HtmlPublisherTarget.this.getBuildArchiveDir(this.build);
            return buildArchiveDir;
        }

        @NonNull
        public HtmlPublisherTarget getHTMLTarget() {
            return HtmlPublisherTarget.this;
        }

        public void onAttached(Run<?, ?> r) {
            this.build = r;
            this.project = r.getParent();
        }

        public void onLoad(Run<?, ?> r) {
            this.build = r;
            this.project = r.getParent();
        }

        public String getWrapperChecksum() {
            return this.wrapperChecksum;
        }

        private void setWrapperChecksum(String wrapperChecksum) {
            this.wrapperChecksum = wrapperChecksum;
        }
    }

    public static class HTMLPublishedForProjectMarkerAction
    extends InvisibleAction
    implements RunAction2 {
        private transient Run<?, ?> build;
        private final HtmlPublisherTarget actualHtmlPublisherTarget;

        public HTMLPublishedForProjectMarkerAction(Run<?, ?> build, HtmlPublisherTarget actualHtmlPublisherTarget) {
            this.actualHtmlPublisherTarget = actualHtmlPublisherTarget;
            this.build = build;
        }

        @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuildOwner")
        public final Run<?, ?> getOwner() {
            return this.build;
        }

        @Deprecated
        private final Object getAbstractBuildOwner(Run build, Class targetClass) {
            return build instanceof AbstractBuild ? (AbstractBuild)build : null;
        }

        public void onAttached(Run<?, ?> r) {
            this.build = r;
        }

        public void onLoad(Run<?, ?> r) {
            this.build = r;
        }

        public HtmlPublisherTarget getHTMLTarget() {
            return this.actualHtmlPublisherTarget;
        }
    }

    public class HTMLAction
    extends BaseHTMLAction
    implements ProminentProjectAction {
        private transient HTMLBuildAction actualBuildAction;

        public HTMLAction(AbstractItem project, HtmlPublisherTarget actualHtmlPublisherTarget) {
            super(actualHtmlPublisherTarget);
            this.project = project;
        }

        @Override
        protected File dir() {
            File javadocDir;
            Job job;
            Run run;
            if (this.project instanceof Job && (run = this.getArchiveBuild(job = (Job)this.project)) != null && (javadocDir = HtmlPublisherTarget.this.getBuildArchiveDir(run)).exists()) {
                for (HTMLBuildAction a : run.getActions(HTMLBuildAction.class)) {
                    if (!a.getHTMLTarget().getReportName().equals(this.getHTMLTarget().getReportName())) continue;
                    this.actualBuildAction = a;
                }
                return javadocDir;
            }
            File projectArchiveDir = HtmlPublisherTarget.this.getProjectArchiveDir(this.project);
            return projectArchiveDir;
        }

        private Run getArchiveBuild(@NonNull Job job) {
            if (this.shouldLinkToLastBuild()) {
                return job.getLastBuild();
            }
            return job.getLastSuccessfulBuild();
        }

        @Override
        protected String getTitle() {
            return this.project.getDisplayName() + " html2";
        }

        @NonNull
        public HtmlPublisherTarget getHTMLTarget() {
            return HtmlPublisherTarget.this;
        }

        @Restricted(value={NoExternalUse.class})
        public HTMLBuildAction getActualBuildAction() {
            return this.actualBuildAction;
        }
    }

    protected abstract class BaseHTMLAction
    implements Action {
        private HtmlPublisherTarget actualHtmlPublisherTarget;
        protected transient AbstractItem project;

        public BaseHTMLAction(HtmlPublisherTarget actualHtmlPublisherTarget) {
            this.actualHtmlPublisherTarget = actualHtmlPublisherTarget;
        }

        public String getUrlName() {
            return this.dir().getName();
        }

        public String getDisplayName() {
            String action = this.actualHtmlPublisherTarget.reportName;
            return this.dir().exists() ? action : null;
        }

        public String getIconFileName() {
            return this.dir().exists() ? "symbol-document-text" : null;
        }

        public String getBackToName() {
            return Encode.forHtml((String)this.project.getDisplayName());
        }

        public String getBackToUrl() {
            return this.project.getUrl();
        }

        public boolean shouldLinkToLastBuild() {
            return this.actualHtmlPublisherTarget.getAlwaysLinkToLastBuild();
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            DirectoryBrowserSupport dbs = new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.dir()), this.getTitle(), "symbol-document-text", false);
            if (req.getRestOfPath().isEmpty()) {
                throw HttpResponses.forwardToView((Object)this, (String)"index.jelly");
            }
            dbs.generateResponse(req, rsp, (Object)this);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }
}

