/*
 * Decompiled with CFR 0.152.
 */
package htmlpublisher.workflow;

import edu.umd.cs.findbugs.annotations.NonNull;
import htmlpublisher.HtmlPublisherTarget;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import jenkins.model.TransientActionFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Restricted(value={DoNotUse.class})
@Extension
public class WorkflowActionsFactory
extends TransientActionFactory<Job> {
    public Class<Job> type() {
        return Job.class;
    }

    @NonNull
    public Collection<? extends Action> createFor(Job j) {
        Run r;
        LinkedList<Action> actions = new LinkedList<Action>();
        if (j.getClass().getCanonicalName().startsWith("org.jenkinsci.plugins.workflow") && (r = j.getLastSuccessfulBuild()) != null) {
            List reports = r.getActions(HtmlPublisherTarget.HTMLBuildAction.class);
            for (HtmlPublisherTarget.HTMLBuildAction report : reports) {
                actions.add(report.getHTMLTarget().getProjectAction((AbstractItem)j));
            }
            List projectLevelReports = r.getActions(HtmlPublisherTarget.HTMLPublishedForProjectMarkerAction.class);
            for (HtmlPublisherTarget.HTMLPublishedForProjectMarkerAction report : projectLevelReports) {
                actions.add(report.getHTMLTarget().getProjectAction((AbstractItem)j));
            }
        }
        return actions;
    }
}

