/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pivovarit.collectors.ParallelCollectors;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.HistoryTestResultSummary;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.TestObjectIterable;
import hudson.tasks.test.TestResultTrendChart;
import hudson.util.RunList;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

@Restricted(value={NoExternalUse.class})
public class History {
    private static final JacksonFacade JACKSON_FACADE = new JacksonFacade();
    private final hudson.tasks.test.TestObject testObject;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    static boolean EXTRA_GRAPH_MATH_ENABLED = Boolean.parseBoolean(System.getProperty(History.class.getName() + ".EXTRA_GRAPH_MATH_ENABLED", "true"));
    private final Object cachedResultLock = new Object();
    private SoftReference<HistoryTableResult> cachedResult = new SoftReference<Object>(null);
    static int parallelism = Math.min(Runtime.getRuntime().availableProcessors(), Math.max(4, (int)((double)Runtime.getRuntime().availableProcessors() * 0.75 * 0.75)));
    static ExecutorService executor = Executors.newFixedThreadPool(Math.max(4, (int)((double)Runtime.getRuntime().availableProcessors() * 0.75 * 0.75)));
    static long MAX_TIME_ELAPSED_RETRIEVING_HISTORY_NS = SystemProperties.getLong((String)(History.class.getName() + ".MAX_TIME_ELAPSED_RETRIEVING_HISTORY_MS"), (Long)15000L) * 1000000L;
    static int MAX_THREADS_RETRIEVING_HISTORY = SystemProperties.getInteger((String)(History.class.getName() + ".MAX_THREADS_RETRIEVING_HISTORY"), (Integer)-1);

    public History(hudson.tasks.test.TestObject testObject) {
        this.testObject = testObject;
    }

    public hudson.tasks.test.TestObject getTestObject() {
        return this.testObject;
    }

    public boolean historyAvailable() {
        return true;
    }

    @JavaScriptMethod
    public String getTestResultTrend(int start, int end, String configuration) {
        return JACKSON_FACADE.toJson((Object)this.createTestResultTrend(start, end, ChartModelConfiguration.fromJson((String)configuration)));
    }

    private LinesChartModel createTestResultTrend(int start, int end, ChartModelConfiguration chartModelConfiguration) {
        TestResultImpl pluggableStorage = this.getPluggableStorage();
        if (pluggableStorage != null) {
            return new TestResultTrendChart().create(pluggableStorage.getTrendTestResultSummary());
        }
        return new TestResultTrendChart().createFromTestObject(this.createBuildHistory(this.testObject, start, end), chartModelConfiguration);
    }

    private ObjectNode computeDurationTrendJson(List<HistoryTestResultSummary> history) {
        double mul;
        String durationStr;
        ObjectNode root = MAPPER.createObjectNode();
        ArrayNode domainAxisLabels = MAPPER.createArrayNode();
        ArrayNode series = MAPPER.createArrayNode();
        ObjectNode durationSeries = MAPPER.createObjectNode();
        series.add((JsonNode)durationSeries);
        durationSeries.put("type", "line");
        durationSeries.put("symbol", "circle");
        durationSeries.put("symbolSize", "6");
        durationSeries.put("sampling", "lttb");
        ArrayNode durationData = MAPPER.createArrayNode();
        durationSeries.set("data", (JsonNode)durationData);
        ObjectNode durationStyle = MAPPER.createObjectNode();
        durationSeries.set("itemStyle", (JsonNode)durationStyle);
        durationStyle.put("color", "rgba(160, 173, 177, 0.6)");
        ObjectNode durationAreaStyle = MAPPER.createObjectNode();
        durationSeries.set("areaStyle", (JsonNode)durationAreaStyle);
        durationAreaStyle.put("normal", true);
        ObjectNode durationMarkLine = MAPPER.createObjectNode();
        durationSeries.set("markLine", (JsonNode)durationMarkLine);
        ArrayNode durationMarkData = MAPPER.createArrayNode();
        durationMarkLine.set("data", (JsonNode)durationMarkData);
        ObjectNode durationAvgMark = MAPPER.createObjectNode();
        ObjectNode hideLabel = MAPPER.createObjectNode();
        hideLabel.put("show", false);
        ObjectNode dashLineStyle = MAPPER.createObjectNode();
        dashLineStyle.put("dashOffset", 50);
        dashLineStyle.put("color", "rgba(128, 128, 128, 0.1)");
        ArrayNode lightDashType = MAPPER.createArrayNode();
        lightDashType.add(5);
        lightDashType.add(10);
        dashLineStyle.set("type", (JsonNode)lightDashType);
        durationAvgMark.put("type", "average");
        durationAvgMark.put("name", "Avg");
        durationAvgMark.set("label", (JsonNode)hideLabel);
        durationAvgMark.set("lineStyle", (JsonNode)dashLineStyle);
        durationMarkData.add((JsonNode)durationAvgMark);
        float maxDuration = 0.0f;
        for (HistoryTestResultSummary h : history) {
            if (!(maxDuration < h.getDuration())) continue;
            maxDuration = h.getDuration();
        }
        ObjectNode yAxis = MAPPER.createObjectNode();
        double roundMul = 1.0;
        if ((double)maxDuration < 0.001) {
            durationStr = "Microseconds";
            mul = 1000000.0;
        } else if (maxDuration < 1.0f) {
            durationStr = "Milliseconds";
            mul = 1000.0;
        } else if (maxDuration < 90.0f) {
            durationStr = "Seconds";
            roundMul = 1000.0;
            mul = 1.0;
        } else if (maxDuration < 5400.0f) {
            durationStr = "Minutes";
            mul = 0.016666666666666666;
            roundMul = 100.0;
        } else {
            durationStr = "Hours";
            mul = 2.777777777777778E-4;
            roundMul = 100.0;
        }
        yAxis.put("name", "Duration (" + durationStr.toLowerCase() + ")");
        durationSeries.put("name", durationStr);
        int index = 0;
        ObjectNode skippedStyle = MAPPER.createObjectNode();
        skippedStyle.put("color", "gray");
        ObjectNode okStyle = MAPPER.createObjectNode();
        okStyle.put("color", "rgba(50, 200, 50, 0.8)");
        float tmpMax = 0.0f;
        double[] lrX = new double[history.size()];
        double[] lrY = new double[history.size()];
        for (HistoryTestResultSummary h : history) {
            lrX[index] = index;
            Run<?, ?> r = h.getRun();
            String fdn = r.getDisplayName();
            domainAxisLabels.add(fdn);
            ObjectNode durationColor = MAPPER.createObjectNode();
            double duration = (double)Math.round(mul * (double)h.getDuration() * roundMul) / roundMul;
            tmpMax = Math.max((float)duration, tmpMax);
            lrY[index] = duration;
            durationColor.put("value", duration);
            if (h.getPassCount() > 0 && h.getFailCount() == 0 && h.getSkipCount() == 0) {
                durationColor.set("itemStyle", (JsonNode)okStyle);
            } else if (h.getFailCount() > 0) {
                ObjectNode failedStyle = MAPPER.createObjectNode();
                double k = Math.min(1.0, (double)h.getFailCount() / ((double)h.getTotalCount() * 0.02));
                failedStyle.put("color", "rgba(255, 100, 100, " + (0.5 + 0.5 * k) + ")");
                durationColor.set("itemStyle", (JsonNode)failedStyle);
            } else {
                durationColor.set("itemStyle", (JsonNode)skippedStyle);
            }
            durationData.add((JsonNode)durationColor);
            ++index;
        }
        if (EXTRA_GRAPH_MATH_ENABLED) {
            this.createLinearTrend(series, history, lrX, lrY, "Trend of " + durationStr, "rgba(0, 120, 255, 0.5)", 0, 0, roundMul);
        }
        root.set("series", (JsonNode)series);
        root.set("domainAxisLabels", (JsonNode)domainAxisLabels);
        root.put("integerRangeAxis", true);
        root.put("domainAxisItemName", "Build");
        if (tmpMax > 50.0f) {
            root.put("rangeMax", (int)Math.ceil(tmpMax));
        } else if ((double)tmpMax > 0.0) {
            root.put("rangeMax", tmpMax);
        } else {
            root.put("rangeMin", 0);
        }
        root.set("yAxis", (JsonNode)yAxis);
        return root;
    }

    private void createLinearTrend(ArrayNode series, List<HistoryTestResultSummary> history, double[] lrX, double[] lrY, String title, String color, int xAxisIndex, int yAxisIndex, double roundMul) {
        if (history.size() < 3) {
            return;
        }
        double[] cs = SimpleLinearRegression.coefficients(lrX, lrY);
        double intercept = cs[0];
        double slope = cs[1];
        ObjectNode lrSeries = MAPPER.createObjectNode();
        series.add((JsonNode)lrSeries);
        lrSeries.put("name", title);
        lrSeries.put("preferScreenOrient", "landscape");
        lrSeries.put("type", "line");
        lrSeries.put("symbol", "circle");
        lrSeries.put("symbolSize", 0);
        lrSeries.put("xAxisIndex", xAxisIndex);
        lrSeries.put("yAxisIndex", yAxisIndex);
        ArrayNode lrData = MAPPER.createArrayNode();
        lrSeries.set("data", (JsonNode)lrData);
        ObjectNode lrStyle = MAPPER.createObjectNode();
        lrSeries.set("itemStyle", (JsonNode)lrStyle);
        lrStyle.put("color", color);
        ObjectNode lrAreaStyle = MAPPER.createObjectNode();
        lrSeries.set("areaStyle", (JsonNode)lrAreaStyle);
        lrAreaStyle.put("color", "rgba(0, 0, 0, 0)");
        if (roundMul < 10.0) {
            roundMul = 10.0;
        }
        for (int index = 0; index < history.size(); ++index) {
            lrData.add((float)((double)Math.round((intercept + (double)index * slope) * roundMul) / roundMul));
        }
    }

    private ObjectNode computeResultTrendJson(List<HistoryTestResultSummary> history) {
        ObjectNode root = MAPPER.createObjectNode();
        ArrayNode domainAxisLabels = MAPPER.createArrayNode();
        ArrayNode series = MAPPER.createArrayNode();
        ObjectNode okSeries = MAPPER.createObjectNode();
        okSeries.put("name", "Passed");
        okSeries.put("xAxisIndex", 1);
        okSeries.put("yAxisIndex", 1);
        okSeries.put("type", "line");
        okSeries.put("symbol", "circle");
        okSeries.put("symbolSize", "0");
        okSeries.put("sampling", "lttb");
        ArrayNode okData = MAPPER.createArrayNode();
        okSeries.set("data", (JsonNode)okData);
        ObjectNode okStyle = MAPPER.createObjectNode();
        okSeries.set("itemStyle", (JsonNode)okStyle);
        okStyle.put("color", "--success-color");
        okSeries.put("stack", "stacked");
        ObjectNode okAreaStyle = MAPPER.createObjectNode();
        okSeries.set("areaStyle", (JsonNode)okAreaStyle);
        okAreaStyle.put("normal", true);
        ObjectNode okMarkLine = MAPPER.createObjectNode();
        okSeries.set("markLine", (JsonNode)okMarkLine);
        ArrayNode okMarkData = MAPPER.createArrayNode();
        okMarkLine.set("data", (JsonNode)okMarkData);
        ObjectNode avgMark = MAPPER.createObjectNode();
        ObjectNode hideLabel = MAPPER.createObjectNode();
        hideLabel.put("show", false);
        ObjectNode dashLineStyle = MAPPER.createObjectNode();
        dashLineStyle.put("dashOffset", 50);
        dashLineStyle.put("color", "rgba(128, 128, 128, 0.1)");
        ArrayNode lightDashType = MAPPER.createArrayNode();
        lightDashType.add(5);
        lightDashType.add(10);
        dashLineStyle.set("type", (JsonNode)lightDashType);
        avgMark.put("type", "average");
        avgMark.put("name", "Avg");
        avgMark.set("label", (JsonNode)hideLabel);
        avgMark.set("lineStyle", (JsonNode)dashLineStyle);
        okMarkData.add((JsonNode)avgMark);
        ObjectNode failSeries = MAPPER.createObjectNode();
        failSeries.put("name", "Failed");
        failSeries.put("type", "line");
        failSeries.put("symbol", "circle");
        failSeries.put("symbolSize", "0");
        failSeries.put("sampling", "lttb");
        failSeries.put("xAxisIndex", 1);
        failSeries.put("yAxisIndex", 1);
        ArrayNode failData = MAPPER.createArrayNode();
        failSeries.set("data", (JsonNode)failData);
        ObjectNode failStyle = MAPPER.createObjectNode();
        failSeries.set("itemStyle", (JsonNode)failStyle);
        failStyle.put("color", "--light-red");
        failSeries.put("stack", "stacked");
        ObjectNode failAreaStyle = MAPPER.createObjectNode();
        failSeries.set("areaStyle", (JsonNode)failAreaStyle);
        failAreaStyle.put("normal", true);
        ObjectNode skipSeries = MAPPER.createObjectNode();
        skipSeries.put("name", "Skipped");
        skipSeries.put("type", "line");
        skipSeries.put("symbol", "circle");
        skipSeries.put("symbolSize", "0");
        skipSeries.put("sampling", "lttb");
        skipSeries.put("xAxisIndex", 1);
        skipSeries.put("yAxisIndex", 1);
        ArrayNode skipData = MAPPER.createArrayNode();
        skipSeries.set("data", (JsonNode)skipData);
        ObjectNode skipStyle = MAPPER.createObjectNode();
        skipSeries.set("itemStyle", (JsonNode)skipStyle);
        skipStyle.put("color", "rgba(160, 173, 177, 0.6)");
        skipSeries.put("stack", "stacked");
        ObjectNode skipAreaStyle = MAPPER.createObjectNode();
        skipSeries.set("areaStyle", (JsonNode)skipAreaStyle);
        skipAreaStyle.put("normal", true);
        ObjectNode totalSeries = MAPPER.createObjectNode();
        totalSeries.put("name", "Total");
        totalSeries.put("type", "line");
        totalSeries.put("symbol", "circle");
        totalSeries.put("symbolSize", "0");
        totalSeries.put("sampling", "lttb");
        totalSeries.put("xAxisIndex", 1);
        totalSeries.put("yAxisIndex", 1);
        ArrayNode totalData = MAPPER.createArrayNode();
        totalSeries.set("data", (JsonNode)totalData);
        ObjectNode lineStyle = MAPPER.createObjectNode();
        totalSeries.set("lineStyle", (JsonNode)lineStyle);
        lineStyle.put("width", 1);
        lineStyle.put("type", "dashed");
        ObjectNode totalStyle = MAPPER.createObjectNode();
        totalSeries.set("itemStyle", (JsonNode)totalStyle);
        totalStyle.put("color", "--light-blue");
        ObjectNode totalAreaStyle = MAPPER.createObjectNode();
        totalSeries.set("areaStyle", (JsonNode)totalAreaStyle);
        totalAreaStyle.put("color", "rgba(0, 0, 0, 0)");
        series.add((JsonNode)skipSeries);
        series.add((JsonNode)failSeries);
        series.add((JsonNode)okSeries);
        series.add((JsonNode)totalSeries);
        int maxTotalCount = 0;
        int index = 0;
        double[] lrX = new double[history.size()];
        double[] lrY = new double[history.size()];
        for (HistoryTestResultSummary h : history) {
            lrX[index] = index;
            Run<?, ?> r = h.getRun();
            String fdn = r.getDisplayName();
            domainAxisLabels.add(fdn);
            lrY[index] = h.getPassCount();
            okData.add(h.getPassCount());
            skipData.add(h.getSkipCount());
            failData.add(h.getFailCount());
            totalData.add(h.getTotalCount());
            if (maxTotalCount < h.getTotalCount()) {
                maxTotalCount = h.getTotalCount();
            }
            ++index;
        }
        if (EXTRA_GRAPH_MATH_ENABLED) {
            this.createLinearTrend(series, history, lrX, lrY, "Trend of Passed", "rgba(50, 50, 255, 0.5)", 1, 1, 10.0);
        }
        root.set("series", (JsonNode)series);
        root.set("domainAxisLabels", (JsonNode)domainAxisLabels);
        root.put("integerRangeAxis", true);
        root.put("domainAxisItemName", "Build");
        root.put("rangeMin", 0);
        return root;
    }

    private ObjectNode computeDistributionJson(List<HistoryTestResultSummary> history) {
        double mul;
        ObjectNode root = MAPPER.createObjectNode();
        ArrayNode series = MAPPER.createArrayNode();
        ObjectNode durationSeries = MAPPER.createObjectNode();
        durationSeries.put("name", "Build Count");
        durationSeries.put("type", "bar");
        durationSeries.put("barWidth", "99%");
        ArrayNode durationData = MAPPER.createArrayNode();
        durationSeries.set("data", (JsonNode)durationData);
        ObjectNode durationStyle = MAPPER.createObjectNode();
        durationSeries.set("itemStyle", (JsonNode)durationStyle);
        durationStyle.put("color", "--success-color");
        series.add((JsonNode)durationSeries);
        double maxDuration = 0.0;
        double minDuration = Double.MAX_VALUE;
        for (HistoryTestResultSummary h : history) {
            if (maxDuration < (double)h.getDuration()) {
                maxDuration = h.getDuration();
            }
            if (!(minDuration > (double)h.getDuration())) continue;
            minDuration = h.getDuration();
        }
        minDuration = Math.max(0.0, minDuration);
        int buckets = 50;
        double[] lrX = new double[buckets];
        double[] lrY = new double[buckets];
        double domain = maxDuration - minDuration;
        double step = domain / (double)buckets;
        for (HistoryTestResultSummary h : history) {
            int idx2;
            int idx = (int)Math.round(((double)h.getDuration() - minDuration) / step);
            int n = idx2 = Math.max(0, Math.min(idx, lrY.length - 1));
            lrY[n] = lrY[n] + 1.0;
        }
        for (int i = 0; i < lrY.length; ++i) {
            lrX[i] = minDuration + step * ((double)i + 0.5);
        }
        ObjectNode xAxis = MAPPER.createObjectNode();
        double roundMul = 1000.0;
        if (maxDuration < 0.001) {
            xAxis.put("name", "Duration (microseconds)");
            mul = 1000000.0;
        } else if (maxDuration < 1.0) {
            xAxis.put("name", "Duration (milliseconds)");
            mul = 1000.0;
        } else if (maxDuration < 90.0) {
            xAxis.put("name", "Duration (seconds)");
            mul = 1.0;
        } else if (maxDuration < 5400.0) {
            xAxis.put("name", "Duration (minutes)");
            mul = 0.016666666666666666;
            roundMul = 100.0;
        } else {
            xAxis.put("name", "Duration (hours)");
            mul = 2.777777777777778E-4;
            roundMul = 100.0;
        }
        xAxis.put("min", (float)(mul * lrX[0] - step * mul * 0.5));
        xAxis.put("max", (float)(mul * lrX[lrX.length - 1] + step * mul * 0.5));
        xAxis.put("interval", (float)(step * mul));
        xAxis.put("roundingFactor", (float)roundMul);
        int maxBuilds = 0;
        for (int i = 0; i < lrY.length; ++i) {
            double scaledX = mul * lrX[i];
            double y = lrY[i];
            ArrayNode data = MAPPER.createArrayNode();
            data.add((float)scaledX);
            data.add((float)y);
            durationData.add((JsonNode)data);
            maxBuilds = Math.max(maxBuilds, (int)Math.ceil(y));
        }
        root.set("series", (JsonNode)series);
        root.put("integerRangeAxis", true);
        root.put("domainAxisItemName", "Number of Builds");
        root.set("xAxis", (JsonNode)xAxis);
        if (maxBuilds >= 10) {
            root.put("rangeMax", maxBuilds);
        }
        return root;
    }

    private ObjectNode computeBuildMapJson(List<HistoryTestResultSummary> history) {
        ObjectNode buildMap = MAPPER.createObjectNode();
        for (HistoryTestResultSummary h : history) {
            Run<?, ?> r = h.getRun();
            String fdn = r.getDisplayName();
            ObjectNode buildObj = MAPPER.createObjectNode();
            buildObj.put("url", h.getUrl());
            buildMap.set(fdn, (JsonNode)buildObj);
        }
        return buildMap;
    }

    private ObjectNode computeTrendJsons(HistoryParseResult parseResult) {
        List<HistoryTestResultSummary> history = parseResult.historySummaries;
        Collections.reverse(history);
        ObjectNode root = MAPPER.createObjectNode();
        root.set("duration", (JsonNode)this.computeDurationTrendJson(history));
        root.set("result", (JsonNode)this.computeResultTrendJson(history));
        root.set("distribution", (JsonNode)this.computeDistributionJson(history));
        root.set("buildMap", (JsonNode)this.computeBuildMapJson(history));
        ObjectNode saveAsImage = MAPPER.createObjectNode();
        if (!history.isEmpty()) {
            saveAsImage.put("name", "test-history-" + history.get(0).getRun().getParent().getFullName() + "-" + history.get(0).getRun().getNumber() + "-" + history.get(history.size() - 1).getRun().getNumber());
        } else {
            saveAsImage.put("name", "test-history");
        }
        root.set("saveAsImage", (JsonNode)saveAsImage);
        ObjectNode status = MAPPER.createObjectNode();
        status.put("hasTimedOut", parseResult.hasTimedOut);
        status.put("buildsRequested", parseResult.buildsRequested);
        status.put("buildsParsed", parseResult.buildsParsed);
        status.put("buildsWithTestResult", parseResult.buildsWithTestResult);
        root.set("status", (JsonNode)status);
        return root;
    }

    private TestObjectIterable createBuildHistory(hudson.tasks.test.TestObject testObject, int start, int end) {
        HistoryTableResult r = this.retrieveHistorySummary(start, end);
        if (!r.getHistorySummaries().isEmpty()) {
            return new TestObjectIterable(testObject, r.getHistorySummaries());
        }
        return null;
    }

    private TestResultImpl getPluggableStorage() {
        TestResultImpl pluggableStorage = null;
        if (this.testObject instanceof TestResult) {
            pluggableStorage = ((TestResult)this.testObject).getPluggableStorage();
        } else if (this.testObject instanceof PackageResult) {
            pluggableStorage = ((PackageResult)this.testObject).getParent().getPluggableStorage();
        } else if (this.testObject instanceof ClassResult) {
            pluggableStorage = ((ClassResult)this.testObject).getParent().getParent().getPluggableStorage();
        } else if (this.testObject instanceof CaseResult) {
            pluggableStorage = ((CaseResult)this.testObject).getParent().getParent().getParent().getPluggableStorage();
        }
        return pluggableStorage;
    }

    public HistoryTableResult retrieveHistorySummary(int start, int end) {
        return this.retrieveHistorySummary(start, end, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryTableResult retrieveHistorySummary(int start, int end, int interval) {
        Object object = this.cachedResultLock;
        synchronized (object) {
            HistoryParseResult parseResult;
            HistoryTableResult result = this.cachedResult.get();
            if (result != null && result.parseResult.start == start && result.parseResult.end == end && result.parseResult.interval == interval) {
                return result;
            }
            TestResultImpl pluggableStorage = this.getPluggableStorage();
            if (pluggableStorage != null) {
                int offset = start;
                if (start > 1000 || start < 0) {
                    offset = 0;
                }
                List<HistoryTestResultSummary> historySummary = pluggableStorage.getHistorySummary(offset);
                parseResult = new HistoryParseResult(historySummary, end - start + 1, start, end);
            } else {
                parseResult = this.getHistoryFromFileStorage(start, end, interval);
            }
            result = new HistoryTableResult(parseResult, this.computeTrendJsons(parseResult));
            this.cachedResult = new SoftReference<HistoryTableResult>(result);
            return result;
        }
    }

    private HistoryParseResult getHistoryFromFileStorage(int start, int end, int interval) {
        hudson.tasks.test.TestObject testObject = this.getTestObject();
        RunList builds = testObject.getRun().getParent().getBuilds();
        int requestedCount = end - start;
        AtomicBoolean hasTimedOut = new AtomicBoolean(false);
        AtomicInteger parsedCount = new AtomicInteger(0);
        long startedNs = System.nanoTime();
        AtomicInteger orderedCount = new AtomicInteger(0);
        List<HistoryTestResultSummary> history = ((Stream)((CompletableFuture)builds.stream().skip(start).limit(requestedCount).filter(build -> {
            if (interval == 1) {
                return true;
            }
            int n = orderedCount.getAndIncrement();
            return n % interval == 0;
        }).collect(ParallelCollectors.parallel(build -> {
            if (System.nanoTime() - startedNs > MAX_TIME_ELAPSED_RETRIEVING_HISTORY_NS) {
                hasTimedOut.set(true);
                return null;
            }
            parsedCount.incrementAndGet();
            TestObject resultInRun = testObject.getResultInRun((Run)build);
            if (resultInRun == null) {
                return null;
            }
            return new HistoryTestResultSummary((Run<?, ?>)build, ((hudson.tasks.test.TestResult)resultInRun).getDuration(), ((hudson.tasks.test.TestResult)resultInRun).getFailCount(), ((hudson.tasks.test.TestResult)resultInRun).getSkipCount(), ((hudson.tasks.test.TestResult)resultInRun).getPassCount(), ((hudson.tasks.test.TestObject)resultInRun).getDescription());
        }, (Executor)executor, (int)(MAX_THREADS_RETRIEVING_HISTORY < 1 ? parallelism : Math.min(parallelism, MAX_THREADS_RETRIEVING_HISTORY))))).join()).filter(Objects::nonNull).collect(Collectors.toList());
        return new HistoryParseResult(history, requestedCount, parsedCount.get(), history.size(), hasTimedOut.get(), start, end, interval);
    }

    public static int asInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    static class SimpleLinearRegression {
        SimpleLinearRegression() {
        }

        static double[] coefficients(double[] xs, double[] ys) {
            int n = xs.length;
            if (n < 2) {
                throw new IllegalArgumentException("At least two data points are required, but got: " + xs.length);
            }
            if (xs.length != ys.length) {
                throw new IllegalArgumentException("Array lengths do not match:" + xs.length + " vs " + ys.length);
            }
            double sumX = 0.0;
            double sumY = 0.0;
            double sumXX = 0.0;
            double sumXY = 0.0;
            for (int i = 0; i < n; ++i) {
                double x = xs[i];
                double y = ys[i];
                sumX += x;
                sumY += y;
                sumXX += x * x;
                sumXY += x * y;
            }
            if (Math.abs(sumXX) < 4.9E-323) {
                return new double[]{Double.NaN, Double.NaN};
            }
            double slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumXX - sumX * sumX);
            double intercept = sumY / (double)n - slope / (double)n * sumX;
            return new double[]{intercept, slope};
        }
    }

    public static class HistoryParseResult {
        List<HistoryTestResultSummary> historySummaries;
        int buildsRequested;
        int buildsParsed;
        int buildsWithTestResult;
        int start;
        int end;
        int interval;
        boolean hasTimedOut;

        public HistoryParseResult(List<HistoryTestResultSummary> historySummaries, int buildsRequested, int buildsParsed, int buildsWithTestResult, boolean hasTimedOut, int start, int end, int interval) {
            this.buildsRequested = buildsRequested;
            this.historySummaries = historySummaries;
            this.buildsParsed = buildsParsed;
            this.buildsWithTestResult = buildsWithTestResult;
            this.hasTimedOut = hasTimedOut;
            this.start = start;
            this.end = end;
            this.interval = interval;
        }

        public HistoryParseResult(List<HistoryTestResultSummary> historySummaries, int buildsRequested, int start, int end) {
            this(historySummaries, buildsRequested, -1, -1, false, start, end, 1);
        }
    }

    public static class HistoryTableResult {
        private final boolean descriptionAvailable;
        private final List<HistoryTestResultSummary> historySummaries;
        private final String trendChartJson;
        public HistoryParseResult parseResult;

        public HistoryTableResult(HistoryParseResult parseResult, ObjectNode json) {
            this.historySummaries = parseResult.historySummaries;
            this.descriptionAvailable = this.historySummaries.stream().anyMatch(summary -> summary.getDescription() != null);
            this.trendChartJson = json.toString();
            this.parseResult = parseResult;
        }

        public boolean isDescriptionAvailable() {
            return this.descriptionAvailable;
        }

        public List<HistoryTestResultSummary> getHistorySummaries() {
            return this.historySummaries;
        }

        public String getTrendChartJson() {
            return this.trendChartJson;
        }
    }
}

