/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.Util;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;

public class HistoryTestResultSummary {
    private final Run<?, ?> run;
    private final float duration;
    private final int failCount;
    private final int skipCount;
    private final int passCount;
    private final String description;

    public HistoryTestResultSummary(Run<?, ?> run, float duration, int failCount, int skipCount, int passCount) {
        this(run, duration, failCount, skipCount, passCount, null);
    }

    public HistoryTestResultSummary(Run<?, ?> run, float duration, int failCount, int skipCount, int passCount, String description) {
        this.run = run;
        this.duration = duration;
        this.failCount = failCount;
        this.skipCount = skipCount;
        this.passCount = passCount;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public float getDuration() {
        return this.duration;
    }

    public String getDurationString() {
        return Util.getTimeSpanString((long)((long)(this.duration * 1000.0f)));
    }

    public int getFailCount() {
        return this.failCount;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    public int getPassCount() {
        return this.passCount;
    }

    public int getTotalCount() {
        return this.passCount + this.skipCount + this.failCount;
    }

    public float getBadness() {
        return (float)Math.min(1.0, (double)this.failCount / ((double)this.getTotalCount() * 0.02));
    }

    public String getFullDisplayName() {
        return this.run.getFullDisplayName();
    }

    public String getUrl() {
        AbstractTestResultAction action = (AbstractTestResultAction)this.run.getAction(AbstractTestResultAction.class);
        return this.getRun().getUrl() + action.getUrlName() + "/";
    }
}

