/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.XmlFile;
import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.StdioRetention;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.junit.TimeToFloat;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.MetaTabulatedResult;
import hudson.tasks.test.PipelineBlockWithTests;
import hudson.tasks.test.PipelineTestDetails;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestObject;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jenkins.util.SystemProperties;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.DocumentException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class TestResult
extends MetaTabulatedResult {
    private static final Logger LOGGER = Logger.getLogger(JUnitResultArchiver.class.getName());
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="We do not expect TestResult to be serialized when this field is set.")
    @CheckForNull
    private final TestResultImpl impl;
    private List<SuiteResult> suites = new ArrayList<SuiteResult>();
    private transient Map<String, Collection<SuiteResult>> suitesByName;
    private transient Map<String, List<SuiteResult>> suitesByNode;
    private transient Map<String, PackageResult> byPackages;
    private transient AbstractTestResultAction parentAction;
    private transient TestObject parent;
    private transient int totalTests;
    private transient List<CaseResult> passedTests;
    private transient List<CaseResult> skippedTests;
    private transient int skippedTestsCounter;
    private float duration;
    private boolean skipOldReports;
    private long startTime = -1L;
    private transient List<CaseResult> failedTests;
    private StdioRetention stdioRetention;
    private boolean keepTestNames;
    private boolean keepProperties;
    public static final long FILE_TIME_PRECISION_MARGIN = Long.getLong(TestResult.class.getName() + "filetime.precision.margin", 3000L);
    static final XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
    private static final long serialVersionUID = 1L;

    public TestResult() {
        this(false);
    }

    @Deprecated
    public TestResult(boolean keepLongStdio) {
        this.stdioRetention = StdioRetention.fromKeepLongStdio(keepLongStdio);
        this.keepProperties = false;
        this.keepTestNames = false;
        this.impl = null;
    }

    @Deprecated
    public TestResult(long buildTime, boolean keepLongStdio) throws IOException {
        this.stdioRetention = StdioRetention.fromKeepLongStdio(keepLongStdio);
        this.keepTestNames = false;
        this.keepProperties = false;
        this.impl = null;
    }

    @Deprecated
    public TestResult(long filesTimestamp, DirectoryScanner results) throws IOException {
        this(filesTimestamp, results, false);
    }

    @Deprecated
    public TestResult(long filesTimestamp, DirectoryScanner results, boolean keepLongStdio) throws IOException {
        this(filesTimestamp, results, StdioRetention.fromKeepLongStdio(keepLongStdio), false, false, null, false);
    }

    @Deprecated
    public TestResult(long filesTimestamp, DirectoryScanner results, boolean keepLongStdio, PipelineTestDetails pipelineTestDetails) throws IOException {
        this.stdioRetention = StdioRetention.fromKeepLongStdio(keepLongStdio);
        this.keepProperties = false;
        this.impl = null;
        this.parse(filesTimestamp, results, pipelineTestDetails);
    }

    @Deprecated
    public TestResult(long filesTimestamp, DirectoryScanner results, boolean keepLongStdio, boolean keepProperties, PipelineTestDetails pipelineTestDetails, boolean skipOldReports) throws IOException {
        this(filesTimestamp, results, StdioRetention.fromKeepLongStdio(keepLongStdio), keepProperties, false, pipelineTestDetails, skipOldReports);
    }

    @Deprecated
    public TestResult(long filesTimestamp, DirectoryScanner results, boolean keepLongStdio, boolean keepProperties, boolean keepTestNames, PipelineTestDetails pipelineTestDetails, boolean skipOldReports) throws IOException {
        this(filesTimestamp, results, StdioRetention.fromKeepLongStdio(keepLongStdio), keepProperties, keepTestNames, pipelineTestDetails, skipOldReports);
    }

    public TestResult(long filesTimestamp, DirectoryScanner results, StdioRetention stdioRetention, boolean keepProperties, boolean keepTestNames, PipelineTestDetails pipelineTestDetails, boolean skipOldReports) throws IOException {
        this.stdioRetention = stdioRetention;
        this.keepProperties = keepProperties;
        this.keepTestNames = keepTestNames;
        this.impl = null;
        this.skipOldReports = skipOldReports;
        this.parse(filesTimestamp, results, pipelineTestDetails);
    }

    public TestResult(TestResultImpl impl) {
        this.impl = impl;
        this.stdioRetention = StdioRetention.DEFAULT;
        this.keepProperties = false;
        this.keepTestNames = false;
    }

    @CheckForNull
    public TestResultImpl getPluggableStorage() {
        return this.impl;
    }

    @Override
    public TestObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TestObject parent) {
        this.parent = parent;
    }

    @Override
    public TestResult getTestResult() {
        return this;
    }

    public TestResult(TestResult src) {
        this.stdioRetention = src.stdioRetention;
        this.keepProperties = src.keepProperties;
        this.keepTestNames = src.keepTestNames;
        this.duration = src.duration;
        if (src.suites != null) {
            this.suites = new ArrayList<SuiteResult>();
            for (SuiteResult sr : src.suites) {
                this.suites.add(new SuiteResult(sr));
            }
        } else {
            this.suites = null;
        }
        this.impl = null;
    }

    static XMLInputFactory getXmlFactory() {
        return xmlFactory;
    }

    void parse(XmlFile f) throws XMLStreamException, IOException {
        try (Reader r = f.readRaw();){
            XMLStreamReader reader = TestResult.getXmlFactory().createXMLStreamReader(r);
            while (reader.hasNext()) {
                int event = reader.next();
                if (event != 1 || !reader.getName().getLocalPart().equals("result")) continue;
                this.parseXmlResult(reader, f.getFile().toString());
            }
            r.close();
        }
    }

    private void parseXmlResult(XMLStreamReader reader, String context) throws XMLStreamException {
        String ver = reader.getAttributeValue(null, "plugin");
        block20: while (reader.hasNext()) {
            String elementName;
            int event = reader.next();
            if (event == 2 && reader.getLocalName().equals("result")) {
                return;
            }
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "suites": {
                    this.parseXmlSuites(reader, context, ver);
                    continue block20;
                }
                case "duration": {
                    this.duration = CaseResult.clampDuration(new TimeToFloat(reader.getElementText()).parse());
                    continue block20;
                }
                case "keepLongStdio": {
                    this.stdioRetention = StdioRetention.fromKeepLongStdio(Boolean.parseBoolean(reader.getElementText()));
                    continue block20;
                }
                case "stdioRetention": {
                    this.stdioRetention = StdioRetention.parse(reader.getElementText());
                    continue block20;
                }
                case "keepTestNames": {
                    this.keepTestNames = Boolean.parseBoolean(reader.getElementText());
                    continue block20;
                }
                case "keepProperties": {
                    this.keepProperties = Boolean.parseBoolean(reader.getElementText());
                    continue block20;
                }
                case "skipOldReports": {
                    this.skipOldReports = Boolean.parseBoolean(reader.getElementText());
                    continue block20;
                }
                case "startTime": {
                    this.startTime = Long.parseLong(reader.getElementText());
                    continue block20;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
    }

    private void parseXmlSuites(XMLStreamReader reader, String context, String ver) throws XMLStreamException {
        block6: while (reader.hasNext()) {
            String elementName;
            int event = reader.next();
            if (event == 2 && reader.getLocalName().equals("suites")) {
                return;
            }
            if (event != 1) continue;
            switch (elementName = reader.getLocalName()) {
                case "suite": {
                    this.suites.add(SuiteResult.parse(reader, context, ver));
                    continue block6;
                }
            }
            LOGGER.finest(() -> "Unknown field in " + context + ": " + elementName);
        }
    }

    @Deprecated
    public void parse(long filesTimestamp, DirectoryScanner results) throws IOException {
        this.parse(filesTimestamp, results, null);
    }

    public void parse(long filesTimestamp, DirectoryScanner results, PipelineTestDetails pipelineTestDetails) throws IOException {
        String[] includedFiles = results.getIncludedFiles();
        File baseDir = results.getBasedir();
        this.parse(filesTimestamp, baseDir, pipelineTestDetails, includedFiles);
    }

    @Deprecated
    public void parse(long filesTimestamp, File baseDir, String[] reportFiles) throws IOException {
        this.parse(filesTimestamp, baseDir, null, reportFiles);
    }

    public void parse(long filesTimestamp, File baseDir, PipelineTestDetails pipelineTestDetails, String[] reportFiles) throws IOException {
        List<File> files = Arrays.stream(reportFiles).map(s -> new File(baseDir, (String)s)).collect(Collectors.toList());
        this.parse(filesTimestamp, pipelineTestDetails, files);
    }

    private void parse(long filesTimestamp, PipelineTestDetails pipelineTestDetails, Iterable<File> reportFiles) throws IOException {
        for (File reportFile : reportFiles) {
            if (this.skipOldReports && Files.getLastModifiedTime(reportFile.toPath(), new LinkOption[0]).toMillis() < filesTimestamp - FILE_TIME_PRECISION_MARGIN) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("file " + reportFile + " not parsed: skipOldReports-" + this.skipOldReports + ",lastModified:" + Files.getLastModifiedTime(reportFile.toPath(), new LinkOption[0]).toMillis() + ",filesTimestamp:" + filesTimestamp);
                continue;
            }
            this.parsePossiblyEmpty(reportFile, pipelineTestDetails);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("testSuites size:" + this.getSuites().size());
        }
    }

    @Override
    public hudson.tasks.test.TestResult getPreviousResult() {
        if (this.impl != null) {
            return this.impl.getPreviousResult();
        }
        return super.getPreviousResult();
    }

    @Deprecated
    public void parse(long filesTimestamp, Iterable<File> reportFiles) throws IOException {
        this.parse(filesTimestamp, null, reportFiles);
    }

    public void parse(long filesTimestamp, Iterable<File> reportFiles, PipelineTestDetails pipelineTestDetails) throws IOException {
        this.parse(filesTimestamp, pipelineTestDetails, reportFiles);
    }

    @Deprecated
    public void parse(Iterable<File> reportFiles, PipelineTestDetails pipelineTestDetails) throws IOException {
        for (File reportFile : reportFiles) {
            this.parsePossiblyEmpty(reportFile, pipelineTestDetails);
        }
    }

    private void parsePossiblyEmpty(File reportFile, PipelineTestDetails pipelineTestDetails) throws IOException {
        if (reportFile.length() == 0L) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("reportFile:" + reportFile + " is empty");
            }
            SuiteResult sr = new SuiteResult(reportFile.getName(), "", "", pipelineTestDetails);
            sr.addCase(new CaseResult(sr, "[empty]", "Test report file " + reportFile.getAbsolutePath() + " was length 0"));
            this.add(sr);
        } else {
            this.parse(reportFile, pipelineTestDetails);
        }
    }

    private void add(SuiteResult sr) {
        long suiteStart = sr.getStartTime();
        for (SuiteResult s : this.suites) {
            if (!s.getName().equals(sr.getName()) || !this.eitherNullOrEq(s.getId(), sr.getId()) || !this.nullSafeEq(s.getNodeId(), sr.getNodeId()) || !this.nullSafeEq(s.getEnclosingBlocks(), sr.getEnclosingBlocks()) || !this.nullSafeEq(s.getEnclosingBlockNames(), sr.getEnclosingBlockNames())) continue;
            if (this.startTime == -1L) {
                this.startTime = suiteStart;
            } else if (suiteStart != -1L) {
                this.startTime = Math.min(this.startTime, suiteStart);
            }
            this.duration += sr.getDuration();
            s.merge(sr);
            return;
        }
        if (this.startTime == -1L) {
            this.startTime = suiteStart;
        } else if (suiteStart != -1L) {
            this.startTime = Math.min(this.startTime, suiteStart);
        }
        this.suites.add(sr);
        this.duration += sr.getDuration();
    }

    void merge(TestResult other) {
        for (SuiteResult suite : other.suites) {
            suite.setParent(null);
            this.add(suite);
        }
        this.tally();
    }

    private boolean strictEq(Object lhs, Object rhs) {
        return lhs != null && rhs != null && lhs.equals(rhs);
    }

    private boolean nullSafeEq(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }

    private boolean eitherNullOrEq(Object lhs, Object rhs) {
        return lhs == null || rhs == null || lhs.equals(rhs);
    }

    @Deprecated
    public void parse(File reportFile) throws IOException {
        this.parse(reportFile, null);
    }

    public void parse(File reportFile, PipelineTestDetails pipelineTestDetails) throws IOException {
        if (this.impl != null) {
            throw new IllegalStateException("Cannot reparse using a pluggable impl");
        }
        try {
            List<SuiteResult> suiteResults = SuiteResult.parse(reportFile, this.stdioRetention, this.keepProperties, this.keepTestNames, pipelineTestDetails);
            for (SuiteResult suiteResult : suiteResults) {
                this.add(suiteResult);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("reportFile:" + reportFile + ", lastModified:" + reportFile.lastModified() + " found " + suiteResults.size() + " suite results");
            }
        }
        catch (InterruptedException | RuntimeException e) {
            throw new IOException("Failed to read " + reportFile, e);
        }
        catch (DocumentException e) {
            if (!reportFile.getPath().endsWith(".xml")) {
                throw new IOException("Failed to read " + reportFile + "\nIs this really a JUnit report file? Your configuration must be matching too many files", e);
            }
            SuiteResult sr = new SuiteResult(reportFile.getName(), "", "", null);
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            String error = "Failed to read test report file " + reportFile.getAbsolutePath() + "\n" + writer.toString();
            sr.addCase(new CaseResult(sr, "[failed-to-read]", error));
            this.add(sr);
        }
    }

    public String getDisplayName() {
        return Messages.TestResult_getDisplayName();
    }

    @Override
    public Run<?, ?> getRun() {
        if (this.parentAction != null) {
            return this.parentAction.run;
        }
        if (this.impl == null) {
            return null;
        }
        return this.impl.getRun();
    }

    @Override
    public hudson.tasks.test.TestResult findCorrespondingResult(String id) {
        if (this.getId().equals(id) || id == null) {
            return this;
        }
        String firstElement = null;
        String subId = null;
        int sepIndex = id.indexOf(47);
        if (sepIndex < 0) {
            firstElement = id;
            subId = null;
        } else {
            firstElement = id.substring(0, sepIndex);
            subId = id.substring(sepIndex + 1);
            if (subId.length() == 0) {
                subId = null;
            }
        }
        String packageName = null;
        if (firstElement.equals(this.getId())) {
            sepIndex = subId.indexOf(47);
            if (sepIndex < 0) {
                packageName = subId;
                subId = null;
            } else {
                packageName = subId.substring(0, sepIndex);
                subId = subId.substring(sepIndex + 1);
            }
        } else {
            packageName = firstElement;
            subId = null;
        }
        PackageResult child = this.byPackage(packageName);
        if (child != null) {
            if (subId != null) {
                return child.findCorrespondingResult(subId);
            }
            return child;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return Messages.TestResult_getTitle();
    }

    @Override
    public String getChildTitle() {
        return Messages.TestResult_getChildTitle();
    }

    @Override
    public String getChildType() {
        return "package";
    }

    @Override
    @Exported(visibility=999)
    public float getDuration() {
        if (this.impl != null) {
            return this.impl.getTotalTestDuration();
        }
        return this.duration;
    }

    public void setStartTime(long start) {
        this.startTime = start;
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    @Exported(visibility=999)
    public int getPassCount() {
        if (this.impl != null) {
            return this.impl.getPassCount();
        }
        return this.totalTests - this.getFailCount() - this.getSkipCount();
    }

    @Override
    @Exported(visibility=999)
    public int getFailCount() {
        if (this.impl != null) {
            return this.impl.getFailCount();
        }
        if (this.failedTests == null) {
            return 0;
        }
        return this.failedTests.size();
    }

    @Override
    @Exported(visibility=999)
    public int getSkipCount() {
        if (this.impl != null) {
            return this.impl.getSkipCount();
        }
        return this.skippedTestsCounter;
    }

    @Override
    public int getTotalCount() {
        if (this.impl != null) {
            return this.impl.getTotalCount();
        }
        return super.getTotalCount();
    }

    @Exported(visibility=999)
    public boolean isEmpty() {
        return this.getTotalCount() == 0;
    }

    public List<CaseResult> getFailedTests() {
        if (this.impl != null) {
            return this.impl.getFailedTests();
        }
        return this.failedTests;
    }

    public synchronized List<CaseResult> getPassedTests() {
        if (this.impl != null) {
            return this.impl.getPassedTests();
        }
        if (this.passedTests == null) {
            this.passedTests = new ArrayList<CaseResult>();
            for (SuiteResult s : this.suites) {
                for (CaseResult cr : s.getCases()) {
                    if (!cr.isPassed()) continue;
                    this.passedTests.add(cr);
                }
            }
        }
        return this.passedTests;
    }

    public synchronized List<CaseResult> getSkippedTests() {
        if (this.impl != null) {
            return this.impl.getSkippedTests();
        }
        if (this.skippedTests == null) {
            this.skippedTests = new ArrayList<CaseResult>();
            for (SuiteResult s : this.suites) {
                for (CaseResult cr : s.getCases()) {
                    if (!cr.isSkipped()) continue;
                    this.skippedTests.add(cr);
                }
            }
        }
        return this.skippedTests;
    }

    @Override
    public int getFailedSince() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Run<?, ?> getFailedSinceRun() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStdout() {
        StringBuilder sb = new StringBuilder();
        for (SuiteResult suite : this.suites) {
            sb.append("Standard Out (stdout) for Suite: " + suite.getName());
            sb.append(suite.getStdout());
        }
        return sb.toString();
    }

    @Override
    public String getStderr() {
        StringBuilder sb = new StringBuilder();
        for (SuiteResult suite : this.suites) {
            sb.append("Standard Error (stderr) for Suite: " + suite.getName());
            sb.append(suite.getStderr());
        }
        return sb.toString();
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    @Override
    public String getErrorStackTrace() {
        return "No error stack traces available at this level. Drill down to individual leafNodes to find stack traces.";
    }

    @Override
    public String getErrorDetails() {
        return "No error details available at this level. Drill down to individual leafNodes to find details.";
    }

    @Override
    public boolean isPassed() {
        return this.getFailCount() == 0;
    }

    public Collection<PackageResult> getChildren() {
        if (this.impl != null) {
            return this.impl.getAllPackageResults();
        }
        return this.byPackages.values();
    }

    @Override
    public boolean hasChildren() {
        return !this.suites.isEmpty();
    }

    @Exported(inline=true, visibility=9)
    public Collection<SuiteResult> getSuites() {
        if (this.impl != null) {
            return this.impl.getSuites();
        }
        return this.suites;
    }

    @Override
    public String getName() {
        return "junit";
    }

    @Override
    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals(this.getId())) {
            return this;
        }
        PackageResult result = this.byPackage(token);
        if (result != null) {
            return result;
        }
        return super.getDynamic(token, req, rsp);
    }

    public PackageResult byPackage(String packageName) {
        if (this.impl != null) {
            return this.impl.getPackageResult(packageName);
        }
        return this.byPackages.get(packageName);
    }

    @CheckForNull
    public SuiteResult getSuite(String name) {
        Collection<SuiteResult> suiteResults = this.getSuites(name);
        if (suiteResults.isEmpty()) {
            return null;
        }
        return suiteResults.iterator().next();
    }

    @NonNull
    public Collection<SuiteResult> getSuites(String name) {
        if (this.impl != null) {
            return Collections.singleton(this.impl.getSuite(name));
        }
        return this.suitesByName.getOrDefault(name, Collections.emptyList());
    }

    @NonNull
    public TestResult getResultByNode(@NonNull String nodeId) {
        return this.getResultByNodes(Collections.singletonList(nodeId));
    }

    @NonNull
    public TestResult getResultByNodes(@NonNull List<String> nodeIds) {
        if (this.impl != null) {
            return this.impl.getResultByNodes(nodeIds);
        }
        TestResult result = new TestResult();
        for (String n : nodeIds) {
            List<SuiteResult> suites = this.suitesByNode.get(n);
            if (suites == null) continue;
            for (SuiteResult s : suites) {
                result.add(s);
            }
        }
        result.setParentAction(this.parentAction);
        return result;
    }

    @Override
    public void setParentAction(AbstractTestResultAction action) {
        this.parentAction = action;
        this.tally();
    }

    @Override
    public AbstractTestResultAction getParentAction() {
        return this.parentAction;
    }

    @Override
    public void tally() {
        this.suitesByName = new HashMap<String, Collection<SuiteResult>>();
        this.suitesByNode = new HashMap<String, List<SuiteResult>>();
        this.testsByBlock = new HashMap();
        this.failedTests = new ArrayList<CaseResult>();
        this.skippedTests = null;
        this.passedTests = null;
        this.byPackages = new TreeMap<String, PackageResult>();
        this.totalTests = 0;
        this.skippedTestsCounter = 0;
        for (SuiteResult s : this.suites) {
            s.setParent(this);
            this.suitesByName.merge(s.getName(), Collections.singleton(s), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()));
            if (s.getNodeId() != null) {
                this.addSuiteByNode(s);
            }
            List<CaseResult> cases = s.getCases();
            for (CaseResult cr : cases) {
                cr.setParentAction(this.parentAction);
                cr.setParentSuiteResult(s);
                cr.tally();
                String pkg = cr.getPackageName();
                String spkg = TestResult.safe(pkg);
                PackageResult pr = this.byPackage(spkg);
                if (pr == null) {
                    pr = new PackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                if (pr.getStartTime() == -1L) {
                    pr.setStartTime(s.getStartTime());
                } else if (s.getStartTime() != -1L) {
                    pr.setStartTime(Math.min(pr.getStartTime(), s.getStartTime()));
                }
                pr.add(cr);
            }
        }
        for (PackageResult pr : this.byPackages.values()) {
            pr.tally();
            this.skippedTestsCounter += pr.getSkipCount();
            this.failedTests.addAll(pr.getFailedTests());
            this.totalTests += pr.getTotalCount();
        }
    }

    public void freeze(TestResultAction parent) {
        assert (this.impl == null);
        this.parentAction = parent;
        if (this.suitesByName == null) {
            this.suitesByName = new HashMap<String, Collection<SuiteResult>>();
            this.suitesByNode = new HashMap<String, List<SuiteResult>>();
            this.testsByBlock = new HashMap();
            this.totalTests = 0;
            this.failedTests = new ArrayList<CaseResult>();
            this.skippedTests = null;
            this.passedTests = null;
            this.byPackages = new TreeMap<String, PackageResult>();
        }
        for (SuiteResult s : this.suites) {
            if (!s.freeze(this)) continue;
            this.suitesByName.merge(s.getName(), Collections.singleton(s), (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()));
            if (s.getNodeId() != null) {
                this.addSuiteByNode(s);
            }
            this.totalTests += s.getCases().size();
            for (CaseResult cr : s.getCases()) {
                String pkg;
                String spkg;
                PackageResult pr;
                if (cr.isSkipped()) {
                    ++this.skippedTestsCounter;
                    if (this.skippedTests != null) {
                        this.skippedTests.add(cr);
                    }
                } else if (!cr.isPassed()) {
                    this.failedTests.add(cr);
                } else if (this.passedTests != null) {
                    this.passedTests.add(cr);
                }
                if ((pr = this.byPackage(spkg = TestResult.safe(pkg = cr.getPackageName()))) == null) {
                    pr = new PackageResult(this, pkg);
                    this.byPackages.put(spkg, pr);
                }
                if (pr.getStartTime() == -1L) {
                    pr.setStartTime(s.getStartTime());
                } else if (s.getStartTime() != -1L) {
                    pr.setStartTime(Math.min(pr.getStartTime(), s.getStartTime()));
                }
                pr.add(cr);
            }
        }
        this.failedTests.sort(CaseResult.BY_AGE);
        if (this.passedTests != null) {
            this.passedTests.sort(CaseResult.BY_AGE);
        }
        if (this.skippedTests != null) {
            this.skippedTests.sort(CaseResult.BY_AGE);
        }
        for (PackageResult pr : this.byPackages.values()) {
            pr.freeze();
        }
    }

    private void addSuiteByNode(SuiteResult s) {
        String nodeId = s.getNodeId();
        if (nodeId != null) {
            if (this.suitesByNode.get(nodeId) == null) {
                this.suitesByNode.put(nodeId, new ArrayList());
            }
            this.suitesByNode.get(nodeId).add(s);
            ArrayList<String> enclosingBlocks = new ArrayList<String>(s.getEnclosingBlocks());
            if (!enclosingBlocks.isEmpty()) {
                this.populateBlocks(enclosingBlocks, nodeId, null);
            }
        }
    }

    @NonNull
    public TestResult getResultForPipelineBlock(@NonNull String blockId) {
        PipelineBlockWithTests block = this.getPipelineBlockWithTests(blockId);
        if (block != null) {
            return (TestResult)this.blockToTestResult(block, this);
        }
        return this;
    }

    public boolean isSkipOldReports() {
        return this.skipOldReports;
    }

    public void setSkipOldReports(boolean skipOldReports) {
        this.skipOldReports = skipOldReports;
    }

    @Override
    @NonNull
    public TabulatedResult blockToTestResult(@NonNull PipelineBlockWithTests block, @NonNull TabulatedResult fullResult) {
        TestResult result = new TestResult();
        for (PipelineBlockWithTests child : block.getChildBlocks().values()) {
            TabulatedResult childResult = this.blockToTestResult(child, fullResult);
            if (!(childResult instanceof TestResult)) continue;
            for (SuiteResult s : ((TestResult)childResult).getSuites()) {
                result.add(s);
            }
        }
        if (fullResult instanceof TestResult) {
            TestResult leafResult = ((TestResult)fullResult).getResultByNodes(new ArrayList<String>(block.getLeafNodes()));
            for (SuiteResult s : leafResult.getSuites()) {
                result.add(s);
            }
        }
        result.setParentAction(fullResult.getParentAction());
        return result;
    }

    public CaseResult getCase(String suiteName, String transformedFullDisplayName) {
        return this.getSuites(suiteName).stream().map(suite -> suite.getCase(transformedFullDisplayName)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        if (SystemProperties.getBoolean((String)(TestResult.class.getName() + ".USE_SAFE_XML_FACTORY"), (boolean)true)) {
            xmlFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
            xmlFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        }
    }
}

