/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestResult;
import java.io.Serializable;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class TestResultSummary
implements Serializable {
    private int failCount;
    private int skipCount;
    private int passCount;
    private int totalCount;

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public TestResultSummary() {
    }

    public TestResultSummary(int failCount, int skipCount, int passCount, int totalCount) {
        this.failCount = failCount;
        this.skipCount = skipCount;
        this.passCount = passCount;
        this.totalCount = totalCount;
    }

    public TestResultSummary(TestResult result) {
        this.failCount = result.getFailCount();
        this.skipCount = result.getSkipCount();
        this.passCount = result.getPassCount();
        this.totalCount = result.getTotalCount();
        if (this.totalCount == 0) {
            for (SuiteResult suite : result.getSuites()) {
                if (suite.getCases().isEmpty()) continue;
                throw new IllegalArgumentException("Attempt to construct TestResultSummary from TestResult without calling tally/freeze");
            }
        }
    }

    @Whitelisted
    public int getFailCount() {
        return this.failCount;
    }

    @Whitelisted
    public int getSkipCount() {
        return this.skipCount;
    }

    @Whitelisted
    public int getPassCount() {
        return this.passCount;
    }

    @Whitelisted
    public int getTotalCount() {
        return this.totalCount;
    }
}

