/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.tasks.junit.TestResultSummary;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class TrendTestResultSummary
implements Serializable {
    private int buildNumber;
    private TestResultSummary testResultSummary;

    public TrendTestResultSummary(int buildNumber, TestResultSummary testResultSummary) {
        this.buildNumber = buildNumber;
        this.testResultSummary = testResultSummary;
    }

    public Map<String, Integer> toMap() {
        HashMap<String, Integer> series = new HashMap<String, Integer>();
        int totalCount = this.testResultSummary.getTotalCount();
        int failCount = this.testResultSummary.getFailCount();
        int skipCount = this.testResultSummary.getSkipCount();
        series.put("total", totalCount);
        series.put("passed", totalCount - failCount - skipCount);
        series.put("failed", failCount);
        series.put("skipped", skipCount);
        return series;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public String getDisplayName() {
        return "#" + this.buildNumber;
    }

    public TestResultSummary getTestResultSummary() {
        return this.testResultSummary;
    }
}

