/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.tasks.test.PipelineBlockWithTests;
import hudson.tasks.test.TestResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class TabulatedResult
extends TestResult {
    protected transient Map<String, PipelineBlockWithTests> testsByBlock;

    public abstract Collection<? extends TestResult> getChildren();

    public abstract boolean hasChildren();

    public boolean hasMultipleBlocks() {
        if (this.testsByBlock != null && this.testsByBlock.size() > 1) {
            int nonNested = 0;
            for (PipelineBlockWithTests b : this.testsByBlock.values()) {
                if (b.getLeafNodes().isEmpty()) continue;
                ++nonNested;
            }
            return nonNested > 1;
        }
        return false;
    }

    @CheckForNull
    public PipelineBlockWithTests getPipelineBlockWithTests(@NonNull String blockId) {
        if (this.testsByBlock.containsKey(blockId)) {
            return this.testsByBlock.get(blockId);
        }
        return null;
    }

    protected final void populateBlocks(@NonNull List<String> innermostFirst, @NonNull String nodeId, @CheckForNull PipelineBlockWithTests nested) {
        if (innermostFirst.isEmpty()) {
            if (nested != null) {
                this.addOrMergeBlock(nested);
            }
        } else {
            String innermost = innermostFirst.remove(0);
            if (nested == null) {
                nested = new PipelineBlockWithTests(innermost);
                nested.addLeafNode(nodeId);
                this.addOrMergeBlock(nested);
                this.populateBlocks(innermostFirst, nodeId, nested);
            } else {
                PipelineBlockWithTests nextLevel = new PipelineBlockWithTests(innermost);
                nextLevel.addChildBlock(nested);
                this.addOrMergeBlock(nextLevel);
                this.populateBlocks(innermostFirst, nodeId, nextLevel);
            }
        }
    }

    private void addOrMergeBlock(@NonNull PipelineBlockWithTests b) {
        if (this.testsByBlock.containsKey(b.getBlockId())) {
            this.testsByBlock.get(b.getBlockId()).merge(b);
        } else {
            this.testsByBlock.put(b.getBlockId(), b);
        }
    }

    @NonNull
    public TabulatedResult blockToTestResult(@NonNull PipelineBlockWithTests block, @NonNull TabulatedResult fullResult) {
        return fullResult;
    }

    public String getChildTitle() {
        return "";
    }

    public String getChildType() {
        return "";
    }
}

