/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mailer.tasks;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import hudson.tasks.Mailer;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;

public class MimeMessageBuilder {
    private static final Logger LOGGER = Logger.getLogger(MimeMessageBuilder.class.getName());
    private static final String PARSING_ADDRESS_ERROR_MESSAGE = "Unable to parse Reply-To Addresses ";
    private String charset = "UTF-8";
    private String mimeType = "text/plain";
    private TaskListener listener;
    private String defaultSuffix;
    private String from;
    private Set<InternetAddress> replyTo = new LinkedHashSet<InternetAddress>();
    private String subject;
    private String body;
    private AddressFilter recipientFilter;
    private Set<InternetAddress> to = new LinkedHashSet<InternetAddress>();
    private Set<InternetAddress> cc = new LinkedHashSet<InternetAddress>();
    private Set<InternetAddress> bcc = new LinkedHashSet<InternetAddress>();

    public MimeMessageBuilder() {
        JenkinsLocationConfiguration jlc = JenkinsLocationConfiguration.get();
        if (jlc != null) {
            this.defaultSuffix = Mailer.descriptor().getDefaultSuffix();
            this.from = jlc.getAdminAddress();
            String rto = Mailer.descriptor().getReplyToAddress();
            try {
                this.replyTo.addAll(this.toNormalizedAddresses(rto));
            }
            catch (UnsupportedEncodingException e) {
                this.logError(PARSING_ADDRESS_ERROR_MESSAGE + rto, e);
            }
        }
    }

    public MimeMessageBuilder setCharset(@NonNull String charset) {
        this.charset = charset;
        return this;
    }

    public MimeMessageBuilder setMimeType(@NonNull String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    public MimeMessageBuilder setListener(TaskListener listener) {
        this.listener = listener;
        return this;
    }

    public MimeMessageBuilder setDefaultSuffix(@NonNull String defaultSuffix) {
        this.defaultSuffix = defaultSuffix;
        return this;
    }

    public MimeMessageBuilder setFrom(@NonNull String from) {
        this.from = from;
        return this;
    }

    public MimeMessageBuilder setReplyTo(@NonNull String replyTo) {
        try {
            List<InternetAddress> addresses = this.toNormalizedAddresses(replyTo);
            this.replyTo.clear();
            this.replyTo.addAll(addresses);
        }
        catch (UnsupportedEncodingException e) {
            this.logError(PARSING_ADDRESS_ERROR_MESSAGE + replyTo, e);
        }
        return this;
    }

    public MimeMessageBuilder addReplyTo(@NonNull String replyTo) {
        try {
            this.replyTo.addAll(this.toNormalizedAddresses(replyTo));
        }
        catch (UnsupportedEncodingException e) {
            this.logError(PARSING_ADDRESS_ERROR_MESSAGE + replyTo, e);
        }
        return this;
    }

    public MimeMessageBuilder setSubject(@NonNull String subject) {
        this.subject = subject;
        return this;
    }

    public MimeMessageBuilder setBody(@NonNull String body) {
        this.body = body;
        return this;
    }

    public MimeMessageBuilder setRecipientFilter(AddressFilter recipientFilter) {
        this.recipientFilter = recipientFilter;
        return this;
    }

    public MimeMessageBuilder addRecipients(@NonNull String recipients) throws UnsupportedEncodingException {
        this.addRecipients(recipients, Message.RecipientType.TO);
        return this;
    }

    public MimeMessageBuilder addRecipients(@NonNull String recipients, @NonNull Message.RecipientType recipientType) throws UnsupportedEncodingException {
        StringTokenizer tokens = new StringTokenizer(recipients, " \t\n\r\f,");
        while (tokens.hasMoreTokens()) {
            String addressToken = tokens.nextToken();
            InternetAddress internetAddress = this.toNormalizedAddress(addressToken);
            if (internetAddress == null) continue;
            if (recipientType == Message.RecipientType.TO) {
                this.to.add(internetAddress);
                continue;
            }
            if (recipientType == Message.RecipientType.CC) {
                this.cc.add(internetAddress);
                continue;
            }
            if (recipientType != Message.RecipientType.BCC) continue;
            this.bcc.add(internetAddress);
        }
        return this;
    }

    public MimeMessage buildMimeMessage() throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
        this.setJenkinsInstanceIdent(msg);
        msg.setContent((Object)"", this.contentType());
        if (StringUtils.isNotBlank((String)this.from)) {
            msg.setFrom((Address)this.toNormalizedAddress(this.from));
        }
        msg.setSentDate(new Date());
        this.addSubject(msg);
        this.addBody(msg);
        this.addRecipients(msg);
        if (!this.replyTo.isEmpty()) {
            msg.setReplyTo(MimeMessageBuilder.toAddressArray(this.replyTo));
        }
        return msg;
    }

    private void setJenkinsInstanceIdent(MimeMessage msg) throws MessagingException {
        if (Jenkins.getInstanceOrNull() != null) {
            String encodedIdentity;
            try {
                RSAPublicKey publicKey = InstanceIdentity.get().getPublic();
                encodedIdentity = Base64.getEncoder().encodeToString(publicKey.getEncoded());
            }
            catch (Throwable t) {
                this.logError("Failed to set Jenkins Identity header on email.", t);
                return;
            }
            msg.setHeader("X-Instance-Identity", encodedIdentity);
        }
    }

    private static Address[] toAddressArray(Collection<InternetAddress> c) {
        if (c == null || c.isEmpty()) {
            return new Address[0];
        }
        Address[] addresses = new Address[c.size()];
        c.toArray(addresses);
        return addresses;
    }

    public static void setInReplyTo(@NonNull MimeMessage msg, @NonNull String inReplyTo) throws MessagingException {
        msg.setHeader("In-Reply-To", inReplyTo);
        msg.setHeader("References", inReplyTo);
    }

    private void addSubject(MimeMessage msg) throws MessagingException {
        if (this.subject != null) {
            msg.setSubject(this.subject);
        }
    }

    private void addBody(MimeMessage msg) throws MessagingException {
        if (this.body != null) {
            MimeMultipart multipart = new MimeMultipart();
            MimeBodyPart bodyPart = new MimeBodyPart();
            bodyPart.setContent((Object)this.body, this.contentType());
            multipart.addBodyPart((BodyPart)bodyPart);
            msg.setContent((Multipart)multipart);
        }
    }

    private String contentType() {
        return String.format("%s; charset=%s", this.mimeType, MimeUtility.quote((String)this.charset, (String)"()<>@,;:\\\"\t []/?="));
    }

    private void addRecipients(MimeMessage msg) throws UnsupportedEncodingException, MessagingException {
        this.addRecipients(msg, this.to, Message.RecipientType.TO);
        this.addRecipients(msg, this.cc, Message.RecipientType.CC);
        this.addRecipients(msg, this.bcc, Message.RecipientType.BCC);
    }

    private void addRecipients(MimeMessage msg, Set<InternetAddress> recipientList, Message.RecipientType recipientType) throws UnsupportedEncodingException, MessagingException {
        if (recipientList.isEmpty()) {
            return;
        }
        Set<InternetAddress> recipients = this.recipientFilter != null ? this.recipientFilter.apply(recipientList) : recipientList;
        msg.setRecipients(recipientType, MimeMessageBuilder.toAddressArray(recipients));
    }

    private List<InternetAddress> toNormalizedAddresses(String addresses) throws UnsupportedEncodingException {
        LinkedList<InternetAddress> list = new LinkedList<InternetAddress>();
        if (StringUtils.isNotBlank((String)addresses)) {
            StringTokenizer tokens = new StringTokenizer(addresses, " \t\n\r\f,");
            while (tokens.hasMoreTokens()) {
                String addressToken = tokens.nextToken();
                InternetAddress internetAddress = this.toNormalizedAddress(addressToken);
                if (internetAddress == null) continue;
                list.add(internetAddress);
            }
        }
        return list;
    }

    private InternetAddress toNormalizedAddress(String address) throws UnsupportedEncodingException {
        if (address == null) {
            return null;
        }
        if (!address.contains("@")) {
            if (this.defaultSuffix != null && this.defaultSuffix.contains("@")) {
                address = address + this.defaultSuffix;
            } else {
                return null;
            }
        }
        try {
            return Mailer.stringToAddress(address, this.charset);
        }
        catch (AddressException e) {
            this.logError("Unable to send to address: " + address, e);
            return null;
        }
    }

    private void logError(String message, Throwable t) {
        if (this.listener != null) {
            t.printStackTrace(this.listener.error(message));
        } else {
            LOGGER.log(Level.WARNING, message, t);
        }
    }

    public static interface AddressFilter {
        public Set<InternetAddress> apply(Set<InternetAddress> var1);
    }
}

