/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.matrixauth.AbstractAuthorizationContainerConverter;
import org.jenkinsci.plugins.matrixauth.AuthorizationProperty;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.NonInheritingStrategy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public abstract class AbstractAuthorizationPropertyConverter<T extends AuthorizationProperty>
extends AbstractAuthorizationContainerConverter<T> {
    private static final Logger LOGGER = Logger.getLogger(AbstractAuthorizationPropertyConverter.class.getName());

    @Override
    public abstract boolean canConvert(Class var1);

    @Override
    public abstract T create();

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        AuthorizationProperty authorizationProperty = (AuthorizationProperty)source;
        InheritanceStrategy strategy = authorizationProperty.getInheritanceStrategy();
        if (strategy != null) {
            writer.startNode("inheritanceStrategy");
            writer.addAttribute("class", ((Object)((Object)strategy)).getClass().getCanonicalName());
            writer.endNode();
        }
        super.marshal(source, writer, context);
    }

    @Override
    protected void unmarshalContainer(T container, HierarchicalStreamReader reader, UnmarshallingContext context) {
        String prop = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
        if (prop != null && prop.equals("useProjectSecurity")) {
            reader.moveDown();
            reader.getValue();
            reader.moveUp();
            prop = ((ExtendedHierarchicalStreamReader)reader).peekNextChild();
        }
        if ("blocksInheritance".equals(prop)) {
            reader.moveDown();
            boolean blocksInheritance = "true".equals(reader.getValue());
            if (blocksInheritance) {
                container.setInheritanceStrategy(new NonInheritingStrategy());
            }
            reader.moveUp();
        }
        if ("inheritanceStrategy".equals(prop)) {
            reader.moveDown();
            String clazz = reader.getAttribute("class");
            try {
                container.setInheritanceStrategy((InheritanceStrategy)((Object)Class.forName(clazz).newInstance()));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to restore inheritance strategy", e);
            }
            reader.moveUp();
        }
        super.unmarshalContainer(container, reader, context);
    }
}

