// CHECKSTYLE:OFF

package org.jenkinsci.plugins.matrixauth.inheritance;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code InheritGlobalStrategy.DisplayName}: {@code Inherit globally
     * defined permissions}.
     * 
     * @return
     *     {@code Inherit globally defined permissions}
     */
    public static String InheritGlobalStrategy_DisplayName() {
        return holder.format("InheritGlobalStrategy.DisplayName");
    }

    /**
     * Key {@code InheritGlobalStrategy.DisplayName}: {@code Inherit globally
     * defined permissions}.
     * 
     * @return
     *     {@code Inherit globally defined permissions}
     */
    public static Localizable _InheritGlobalStrategy_DisplayName() {
        return new Localizable(holder, "InheritGlobalStrategy.DisplayName");
    }

    /**
     * Key {@code InheritParentStrategy.DisplayName}: {@code Inherit
     * permissions from parent ACL}.
     * 
     * @return
     *     {@code Inherit permissions from parent ACL}
     */
    public static String InheritParentStrategy_DisplayName() {
        return holder.format("InheritParentStrategy.DisplayName");
    }

    /**
     * Key {@code InheritParentStrategy.DisplayName}: {@code Inherit
     * permissions from parent ACL}.
     * 
     * @return
     *     {@code Inherit permissions from parent ACL}
     */
    public static Localizable _InheritParentStrategy_DisplayName() {
        return new Localizable(holder, "InheritParentStrategy.DisplayName");
    }

    /**
     * Key {@code NonInheritingStrategy.DisplayName}: {@code Do not inherit
     * permission grants from other ACLs}.
     * 
     * @return
     *     {@code Do not inherit permission grants from other ACLs}
     */
    public static String NonInheritingStrategy_DisplayName() {
        return holder.format("NonInheritingStrategy.DisplayName");
    }

    /**
     * Key {@code NonInheritingStrategy.DisplayName}: {@code Do not inherit
     * permission grants from other ACLs}.
     * 
     * @return
     *     {@code Do not inherit permission grants from other ACLs}
     */
    public static Localizable _NonInheritingStrategy_DisplayName() {
        return new Localizable(holder, "NonInheritingStrategy.DisplayName");
    }

}
