/*
 * Decompiled with CFR 0.152.
 */
package hudson.matrix;

import hudson.Extension;
import hudson.Functions;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.Messages;
import hudson.model.labels.LabelAtom;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class LabelAxis
extends Axis {
    @DataBoundConstructor
    public LabelAxis(String name, List<String> values) {
        super(name, values);
    }

    @Override
    public boolean isSystem() {
        return true;
    }

    @Override
    public String getValueString() {
        return String.join((CharSequence)"/", this.getValues());
    }

    public String getValueStringHtmlEscaped() {
        List<String> values = this.getValues();
        StringBuilder str = new StringBuilder();
        for (String value : values) {
            if (str.length() > 0) {
                str.append('/');
            }
            str.append(Functions.htmlAttributeEscape((String)value));
        }
        return str.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.LabelAxis_DisplayName();
        }

        @Override
        public boolean isInstantiable() {
            Jenkins j = Jenkins.getActiveInstance();
            return !j.getNodes().isEmpty() || !j.clouds.isEmpty();
        }

        public String buildLabelCheckBox(LabelAtom la, LabelAxis instance) {
            String escapedName = Functions.jsStringEscape((String)Functions.htmlAttributeEscape((String)la.getName()));
            String escapedDescription = Functions.jsStringEscape((String)(StringUtils.isEmpty((String)la.getDescription()) ? "" : Functions.htmlAttributeEscape((String)la.getDescription())));
            return "\"" + Functions.jsStringEscape((String)"<input type='checkbox' name='values' json='") + escapedName + Functions.jsStringEscape((String)"' ") + "\"" + String.format("+has(\"%s\")+", escapedName) + "\"" + Functions.jsStringEscape((String)"/><label class='attach-previous'>") + escapedName + " (" + escapedDescription + ")</label>\"";
        }
    }
}

