/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletException;
import jenkins.metrics.api.Messages;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class MetricsAccessKey
extends AbstractDescribableImpl<MetricsAccessKey>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String key;
    @CheckForNull
    private final String description;
    private final boolean canPing;
    private final boolean canThreadDump;
    private final boolean canHealthCheck;
    private final boolean canMetrics;
    private final String origins;
    private transient String[] originRegexs = null;

    public MetricsAccessKey(String description, String key) {
        this(description, key, true, false, false, true, null);
    }

    @DataBoundConstructor
    public MetricsAccessKey(String description, String key, boolean canPing, boolean canThreadDump, boolean canHealthCheck, boolean canMetrics, String origins) {
        this.description = Util.fixEmptyAndTrim((String)description);
        key = Util.fixEmptyAndTrim((String)key);
        this.key = key == null ? DescriptorImpl.generateKey() : key;
        this.canPing = canPing;
        this.canThreadDump = canThreadDump;
        this.canHealthCheck = canHealthCheck;
        this.canMetrics = canMetrics;
        this.origins = origins;
    }

    private static String globToRegex(String line) {
        StringBuilder buf = new StringBuilder(line.length() + 16);
        boolean escaping = false;
        int braceDepth = 0;
        block9: for (char c : line.toCharArray()) {
            switch (c) {
                case '*': {
                    if (escaping) {
                        buf.append("\\*");
                    } else {
                        buf.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        buf.append("\\?");
                    } else {
                        buf.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    buf.append('\\');
                    buf.append(c);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        buf.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        buf.append("\\{");
                    } else {
                        buf.append('(');
                        ++braceDepth;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (braceDepth > 0 && !escaping) {
                        buf.append(')');
                        --braceDepth;
                    } else if (escaping) {
                        buf.append("\\}");
                    } else {
                        buf.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (braceDepth > 0 && !escaping) {
                        buf.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        buf.append("\\,");
                        continue block9;
                    }
                    buf.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    public boolean isCanPing() {
        return this.canPing;
    }

    public boolean isCanThreadDump() {
        return this.canThreadDump;
    }

    public boolean isCanHealthCheck() {
        return this.canHealthCheck;
    }

    public boolean isCanMetrics() {
        return this.canMetrics;
    }

    public String getOrigins() {
        return this.origins;
    }

    public boolean isOriginAllowed(String origin) {
        if (this.originRegexs == null) {
            if (StringUtils.equals((String)"*", (String)StringUtils.defaultIfBlank((String)this.origins, (String)"*").trim())) {
                this.originRegexs = new String[]{".*"};
            } else {
                ArrayList<String> regexs = new ArrayList<String>();
                String[] stringArray = StringUtils.split((String)this.origins, (String)" ,");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String pattern = stringArray[i];
                    if (StringUtils.isBlank((String)pattern)) continue;
                    String[] parts = StringUtils.split((String)pattern, (String)":");
                    if (parts.length > 3) {
                        regexs.add(MetricsAccessKey.globToRegex(parts[0]) + ":" + MetricsAccessKey.globToRegex(parts[1]) + ":" + MetricsAccessKey.globToRegex(parts[2]));
                        continue;
                    }
                    if (parts.length == 3) {
                        regexs.add(MetricsAccessKey.globToRegex(parts[0]) + ":" + MetricsAccessKey.globToRegex(parts[1]) + ":" + MetricsAccessKey.globToRegex(parts[2]));
                        continue;
                    }
                    if (parts.length == 2) {
                        if (parts[1].matches("^\\d{1,5}$")) {
                            regexs.add(".*:" + MetricsAccessKey.globToRegex(parts[0]) + ":" + parts[1]);
                            continue;
                        }
                        regexs.add(MetricsAccessKey.globToRegex(parts[0]) + ":" + MetricsAccessKey.globToRegex(parts[1]) + "(:.*)?");
                        continue;
                    }
                    if (parts.length != 1) continue;
                    regexs.add(".*:" + MetricsAccessKey.globToRegex(pattern) + "(:.*)?");
                }
                this.originRegexs = regexs.toArray(new String[regexs.size()]);
            }
        }
        for (String regex : this.originRegexs) {
            if (!origin.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricsAccessKey that = (MetricsAccessKey)o;
        if (this.canHealthCheck != that.canHealthCheck) {
            return false;
        }
        if (this.canMetrics != that.canMetrics) {
            return false;
        }
        if (this.canPing != that.canPing) {
            return false;
        }
        if (this.canThreadDump != that.canThreadDump) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.key.equals(that.key)) {
            return false;
        }
        return !(this.origins != null ? !this.origins.equals(that.origins) : that.origins != null);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MetricsAccessKey{");
        sb.append("key='").append(this.key).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", canPing=").append(this.canPing);
        sb.append(", canHealthCheck=").append(this.canHealthCheck);
        sb.append(", canMetrics=").append(this.canMetrics);
        sb.append(", canThreadDump=").append(this.canThreadDump);
        sb.append(", origins='").append(this.origins).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static class FixedListProviderImpl
    extends AbstractProvider {
        private static final long serialVersionUID = 1L;
        @CheckForNull
        private final List<MetricsAccessKey> accessKeys;

        public FixedListProviderImpl(@CheckForNull List<MetricsAccessKey> accessKeys) {
            this.accessKeys = accessKeys == null ? null : new ArrayList<MetricsAccessKey>(accessKeys);
        }

        @Override
        @NonNull
        public List<MetricsAccessKey> getAccessKeys() {
            return this.accessKeys == null ? Collections.emptyList() : Collections.unmodifiableList(this.accessKeys);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("FixedListProviderImpl{");
            sb.append("accessKeys=").append(this.accessKeys);
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FixedListProviderImpl that = (FixedListProviderImpl)o;
            return !(this.accessKeys != null ? !this.accessKeys.equals(that.accessKeys) : that.accessKeys != null);
        }

        public int hashCode() {
            return this.accessKeys != null ? this.accessKeys.hashCode() : 0;
        }
    }

    public static abstract class AbstractProvider
    implements Provider {
        private static final long serialVersionUID = 1L;
        private transient Boolean mayHaveOnDemandKeys;

        private boolean isMayHaveOnDemandKeys() {
            if (this.mayHaveOnDemandKeys == null) {
                boolean needsSlow;
                try {
                    Method method = this.getClass().getMethod("getAccessKey", String.class);
                    needsSlow = !method.getDeclaringClass().equals(Provider.class);
                }
                catch (NoSuchMethodException e) {
                    needsSlow = true;
                }
                this.mayHaveOnDemandKeys = needsSlow;
            }
            return this.mayHaveOnDemandKeys;
        }

        @Override
        @CheckForNull
        public MetricsAccessKey getAccessKey(String accessKey) {
            for (MetricsAccessKey k : this.getAccessKeys()) {
                if (!StringUtils.equals((String)accessKey, (String)k.getKey())) continue;
                return k;
            }
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<MetricsAccessKey> {
        private static final SecureRandom entropy = new SecureRandom();
        private static final char[] keyChars = "ABCEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
        @GuardedBy(value="this")
        private List<MetricsAccessKey> accessKeys;
        private volatile transient Set<String> accessKeySet;

        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public static String generateKey() {
            StringBuilder b = new StringBuilder(64);
            for (int i = 0; i < 64; ++i) {
                b.append(keyChars[entropy.nextInt(keyChars.length)]);
            }
            return b.toString();
        }

        public synchronized boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.accessKeys = req.bindJSONToList(MetricsAccessKey.class, json.get("accessKeys"));
            this.accessKeySet = null;
            this.save();
            return true;
        }

        @NonNull
        public synchronized List<MetricsAccessKey> getAccessKeys() {
            return Collections.unmodifiableList(new ArrayList(this.accessKeys == null ? Collections.emptyList() : this.accessKeys));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void checkAccessKey(@CheckForNull String accessKey) {
            Set<String> accessKeySet = this.accessKeySet;
            if (accessKeySet == null) {
                accessKeySet = new HashSet<String>();
                for (Object p : ExtensionList.lookup(Provider.class)) {
                    for (MetricsAccessKey k : p.getAccessKeys()) {
                        accessKeySet.add(k.getKey());
                    }
                }
                Object object = this;
                synchronized (object) {
                    if (this.accessKeys != null) {
                        for (MetricsAccessKey k : this.accessKeys) {
                            accessKeySet.add(k.getKey());
                        }
                    }
                    this.accessKeySet = accessKeySet;
                }
            }
            if (!accessKeySet.contains(accessKey)) {
                for (Object p : ExtensionList.lookup(Provider.class)) {
                    if (p instanceof AbstractProvider && !((AbstractProvider)p).isMayHaveOnDemandKeys() || p.getAccessKey(accessKey) == null) continue;
                    return;
                }
                throw new AccessDeniedException(Messages.MetricsAccessKey_invalidAccessKey(accessKey));
            }
        }

        public boolean hasAccessKeyPing(@CheckForNull String accessKey) {
            this.checkAccessKey(accessKey);
            MetricsAccessKey key = this.getAccessKey(accessKey);
            return key != null && key.isCanPing();
        }

        public boolean hasAccessKeyThreadDump(@CheckForNull String accessKey) {
            this.checkAccessKey(accessKey);
            MetricsAccessKey key = this.getAccessKey(accessKey);
            return key != null && key.isCanThreadDump();
        }

        public boolean hasAccessKeyHealthCheck(@CheckForNull String accessKey) {
            this.checkAccessKey(accessKey);
            MetricsAccessKey key = this.getAccessKey(accessKey);
            return key != null && key.isCanHealthCheck();
        }

        public boolean hasAccessKeyMetrics(@CheckForNull String accessKey) {
            this.checkAccessKey(accessKey);
            MetricsAccessKey key = this.getAccessKey(accessKey);
            return key != null && key.isCanMetrics();
        }

        public void checkAccessKeyPing(@CheckForNull String accessKey) {
            if (!this.hasAccessKeyPing(accessKey)) {
                throw new AccessDeniedException(Messages.MetricsAccessKey_invalidAccessKey(accessKey));
            }
        }

        public void checkAccessKeyThreadDump(@CheckForNull String accessKey) {
            if (!this.hasAccessKeyThreadDump(accessKey)) {
                throw new AccessDeniedException(Messages.MetricsAccessKey_invalidAccessKey(accessKey));
            }
        }

        public void checkAccessKeyHealthCheck(@CheckForNull String accessKey) {
            if (!this.hasAccessKeyHealthCheck(accessKey)) {
                throw new AccessDeniedException(Messages.MetricsAccessKey_invalidAccessKey(accessKey));
            }
        }

        public void checkAccessKeyMetrics(@CheckForNull String accessKey) {
            if (!this.hasAccessKeyMetrics(accessKey)) {
                throw new AccessDeniedException(Messages.MetricsAccessKey_invalidAccessKey(accessKey));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MetricsAccessKey getAccessKey(String accessKey) {
            for (Provider p : ExtensionList.lookup(Provider.class)) {
                MetricsAccessKey key = p.getAccessKey(accessKey);
                if (key == null) continue;
                return key;
            }
            Object object = this;
            synchronized (object) {
                for (MetricsAccessKey k : this.accessKeys) {
                    if (!StringUtils.equals((String)accessKey, (String)k.getKey())) continue;
                    return k;
                }
            }
            return null;
        }

        @DataBoundSetter
        public synchronized void setAccessKeys(List<MetricsAccessKey> accessKeys) {
            this.accessKeys = accessKeys;
        }

        public HttpResponse cors(@CheckForNull String accessKey, final HttpResponse resp) {
            final MetricsAccessKey key = this.getAccessKey(accessKey);
            return key == null ? resp : new HttpResponse(){

                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    String origin = req.getHeader("Origin");
                    if (StringUtils.isNotBlank((String)origin) && key.isOriginAllowed(origin)) {
                        rsp.addHeader("Access-Control-Allow-Origin", origin);
                        rsp.addHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE");
                        rsp.addHeader("Access-Control-Allow-Headers", "Accept, Authorization");
                        if ("OPTIONS".equals(req.getMethod())) {
                            rsp.setStatus(200);
                            return;
                        }
                    }
                    resp.generateResponse(req, rsp, node);
                }
            };
        }

        public String getDisplayName() {
            return Messages.MetricsAccessKey_displayName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reindexAccessKeys() {
            HashSet<String> accessKeySet = new HashSet<String>();
            for (Provider p : ExtensionList.lookup(Provider.class)) {
                for (MetricsAccessKey k : p.getAccessKeys()) {
                    accessKeySet.add(k.getKey());
                }
            }
            Object object = this;
            synchronized (object) {
                if (this.accessKeys != null) {
                    for (MetricsAccessKey k : this.accessKeys) {
                        accessKeySet.add(k.getKey());
                    }
                }
                this.accessKeySet = accessKeySet;
            }
        }
    }

    public static interface Provider
    extends ExtensionPoint,
    Serializable {
        @NonNull
        public List<MetricsAccessKey> getAccessKeys();

        @CheckForNull
        public MetricsAccessKey getAccessKey(String var1);
    }
}

