/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import com.codahale.metrics.health.HealthCheck;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import jenkins.metrics.api.StringImmutableEntry;

public abstract class HealthCheckProvider
implements ExtensionPoint {
    protected static Map.Entry<String, HealthCheck> check(String name, HealthCheck metric) {
        return new StringImmutableEntry<HealthCheck>(name, metric);
    }

    protected static Map.Entry<String, HealthCheck> check(String name, HealthCheck metric, boolean enabled) {
        return new StringImmutableEntry<HealthCheck>(name, (HealthCheck)(enabled ? metric : null));
    }

    protected static Map<String, HealthCheck> checks(Map.Entry<String, HealthCheck> ... metrics) {
        LinkedHashMap<String, HealthCheck> result = new LinkedHashMap<String, HealthCheck>(metrics.length);
        for (Map.Entry<String, HealthCheck> metric : metrics) {
            if (metric.getValue() == null) continue;
            result.put(metric.getKey(), metric.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    @NonNull
    public abstract Map<String, HealthCheck> getHealthChecks();
}

