/*
 * Decompiled with CFR 0.152.
 */
package jenkins.metrics.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.labels.LabelAtom;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class QueueItemMetricsEvent {
    private final long eventTick = System.nanoTime();
    @NonNull
    private final Queue.Item item;
    @CheckForNull
    private final Label assignedLabel;
    @NonNull
    private final State state;
    @CheckForNull
    private final Run<?, ?> run;
    @CheckForNull
    private final Queue.Executable executable;
    @CheckForNull
    private final List<Set<LabelAtom>> consumedLabelAtoms;
    @CheckForNull
    private final Long queuingTotalMillis;
    @CheckForNull
    private final Long queuingWaitingMillis;
    @CheckForNull
    private final Long queuingBlockedMillis;
    @CheckForNull
    private final Long queuingBuildableMillis;
    @CheckForNull
    private final Long executingMillis;
    @CheckForNull
    private final Integer executorCount;

    public QueueItemMetricsEvent(@NonNull Queue.Item item, @CheckForNull Label assignedLabel, @NonNull State state, @CheckForNull Run<?, ?> run, @CheckForNull Queue.Executable executable, @CheckForNull List<Set<LabelAtom>> consumedLabelAtoms, @CheckForNull Long queuingTotalMillis, @CheckForNull Long queuingWaitingMillis, @CheckForNull Long queuingBlockedMillis, @CheckForNull Long queuingBuildableMillis, @CheckForNull Long executingMillis, @CheckForNull Integer executorCount) {
        this.item = item;
        this.assignedLabel = assignedLabel;
        this.state = state;
        this.run = run;
        this.executable = executable;
        this.consumedLabelAtoms = consumedLabelAtoms;
        this.queuingTotalMillis = queuingTotalMillis;
        this.queuingWaitingMillis = queuingWaitingMillis;
        this.queuingBlockedMillis = queuingBlockedMillis;
        this.queuingBuildableMillis = queuingBuildableMillis;
        this.executingMillis = executingMillis;
        this.executorCount = executorCount;
    }

    public static int compareEventSequence(QueueItemMetricsEvent x, QueueItemMetricsEvent y) {
        return Long.compare(x.getEventTick() - y.getEventTick(), 0L);
    }

    public static int compareQueueSequence(QueueItemMetricsEvent x, QueueItemMetricsEvent y) {
        return Long.compare(x.getId() - y.getId(), 0L);
    }

    public long getEventTick() {
        return this.eventTick;
    }

    public long getEventMillis() {
        return System.currentTimeMillis() + TimeUnit.NANOSECONDS.toMillis(this.eventTick - System.nanoTime());
    }

    public long getId() {
        return this.item.getId();
    }

    public State getState() {
        return this.state;
    }

    @NonNull
    public Queue.Item getItem() {
        return this.item;
    }

    @CheckForNull
    public Label getAssignedLabel() {
        return this.assignedLabel;
    }

    public Optional<Run<?, ?>> getRun() {
        return Optional.ofNullable(this.run);
    }

    @NonNull
    public Optional<Queue.Executable> getExecutable() {
        return Optional.ofNullable(this.executable);
    }

    @NonNull
    public Optional<List<Set<LabelAtom>>> getConsumedLabelAtoms() {
        return Optional.ofNullable(this.consumedLabelAtoms);
    }

    @NonNull
    public Optional<Long> getQueuingTotalMillis() {
        return Optional.ofNullable(this.queuingTotalMillis);
    }

    @NonNull
    public Optional<Long> getQueuingWaitingMillis() {
        return Optional.ofNullable(this.queuingWaitingMillis);
    }

    @NonNull
    public Optional<Long> getQueuingBlockedMillis() {
        return Optional.ofNullable(this.queuingBlockedMillis);
    }

    @NonNull
    public Optional<Long> getQueuingBuildableMillis() {
        return Optional.ofNullable(this.queuingBuildableMillis);
    }

    @NonNull
    public Optional<Long> getExecutingMillis() {
        return Optional.ofNullable(this.executingMillis);
    }

    @NonNull
    public Optional<Integer> getExecutorCount() {
        return Optional.ofNullable(this.executorCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueItemMetricsEvent that = (QueueItemMetricsEvent)o;
        if (this.eventTick != that.eventTick) {
            return false;
        }
        if (!this.item.equals(that.item)) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result = (int)(this.eventTick ^ this.eventTick >>> 32);
        result = 31 * result + this.item.hashCode();
        result = 31 * result + this.state.hashCode();
        return result;
    }

    public String toString() {
        return "QueueItemMetricsEvent{event=" + new Date(this.getEventMillis()) + ", item=" + this.item + ", state=" + this.state + ", run=" + this.run + ", executable=" + this.executable + ", queuingTotalMillis=" + this.queuingTotalMillis + ", queuingWaitingMillis=" + this.queuingWaitingMillis + ", queuingBlockedMillis=" + this.queuingBlockedMillis + ", queuingBuildableMillis=" + this.queuingBuildableMillis + ", executingMillis=" + this.executingMillis + ", executorCount=" + this.executorCount + "}";
    }

    public static enum State {
        QUEUED,
        CANCELLED,
        STARTED,
        FINISHED;

    }
}

