/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.pipelinegraphanalysis;

import com.google.common.base.Predicates;
import hudson.model.Action;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.ParallelMemoryFlowChunk;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class StatusAndTiming {
    public static void verifySameRun(@Nonnull WorkflowRun run, FlowNode ... nodes) throws IllegalArgumentException {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        FlowExecution exec = run.getExecution();
        int i = 0;
        for (FlowNode n : nodes) {
            if (n != null && n.getExecution() != exec) {
                throw new IllegalArgumentException("FlowNode not part of the same execution found, at index " + i + " with ID " + n.getId());
            }
            ++i;
        }
    }

    public static boolean isPendingInput(WorkflowRun run) {
        List executions;
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        return inputAction != null && (executions = inputAction.getExecutions()) != null && !executions.isEmpty();
    }

    @CheckForNull
    public static GenericStatus computeChunkStatus(@Nonnull WorkflowRun run, @Nonnull MemoryFlowChunk chunk) {
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return null;
        }
        if (chunk instanceof ParallelMemoryFlowChunk) {
            ParallelMemoryFlowChunk par = (ParallelMemoryFlowChunk)chunk;
            return StatusAndTiming.condenseStatus(StatusAndTiming.computeBranchStatuses(run, par).values());
        }
        return StatusAndTiming.computeChunkStatus(run, chunk.getNodeBefore(), chunk.getFirstNode(), chunk.getLastNode(), chunk.getNodeAfter());
    }

    @CheckForNull
    public static GenericStatus computeChunkStatus(@Nonnull WorkflowRun run, @CheckForNull FlowNode before, @Nonnull FlowNode firstNode, @Nonnull FlowNode lastNode, @CheckForNull FlowNode after) {
        boolean isLastChunk;
        FlowExecution exec = run.getExecution();
        StatusAndTiming.verifySameRun(run, before, firstNode, lastNode, after);
        if (exec == null) {
            return null;
        }
        if (!NotExecutedNodeAction.isExecuted((FlowNode)lastNode)) {
            return GenericStatus.NOT_EXECUTED;
        }
        boolean bl = isLastChunk = after == null || exec.isCurrentHead(lastNode);
        if (isLastChunk) {
            if (run.isBuilding()) {
                BlockStartNode start;
                if (exec.getCurrentHeads().size() > 1 && lastNode instanceof BlockEndNode && (start = ((BlockEndNode)lastNode).getStartNode()).getAction(ThreadNameAction.class) != null) {
                    return lastNode.getError() == null ? GenericStatus.SUCCESS : GenericStatus.FAILURE;
                }
                return StatusAndTiming.isPendingInput(run) ? GenericStatus.PAUSED_PENDING_INPUT : GenericStatus.IN_PROGRESS;
            }
            Result r = run.getResult();
            if (r == Result.NOT_BUILT) {
                return GenericStatus.NOT_EXECUTED;
            }
            if (r == Result.ABORTED) {
                return GenericStatus.ABORTED;
            }
            if (r == Result.FAILURE) {
                return GenericStatus.FAILURE;
            }
            if (r == Result.UNSTABLE) {
                return GenericStatus.UNSTABLE;
            }
            return GenericStatus.SUCCESS;
        }
        ErrorAction err = lastNode.getError();
        if (err != null) {
            return after.getError() == null ? GenericStatus.SUCCESS : GenericStatus.FAILURE;
        }
        return run.getResult() == Result.UNSTABLE ? GenericStatus.UNSTABLE : GenericStatus.SUCCESS;
    }

    @CheckForNull
    public static TimingInfo computeChunkTiming(@Nonnull WorkflowRun run, long internalPauseDuration, @Nonnull MemoryFlowChunk chunk) {
        return StatusAndTiming.computeChunkTiming(run, internalPauseDuration, chunk.getFirstNode(), chunk.getLastNode(), chunk.getNodeAfter());
    }

    @CheckForNull
    public static TimingInfo computeChunkTiming(@Nonnull WorkflowRun run, long internalPauseDuration, @Nonnull FlowNode firstNode, @Nonnull FlowNode lastNode, @CheckForNull FlowNode after) {
        long startTime;
        BlockStartNode start;
        boolean isLastChunk;
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return null;
        }
        if (!NotExecutedNodeAction.isExecuted((FlowNode)lastNode)) {
            return new TimingInfo(0L, 0L, 0L);
        }
        StatusAndTiming.verifySameRun(run, firstNode, lastNode, after);
        long endTime = after != null ? TimingAction.getStartTime((FlowNode)after) : System.currentTimeMillis();
        boolean bl = isLastChunk = after == null || exec.isCurrentHead(lastNode);
        if (isLastChunk && run.isBuilding() && exec.getCurrentHeads().size() > 1 && lastNode instanceof BlockEndNode && (start = ((BlockEndNode)lastNode).getStartNode()).getAction(ThreadNameAction.class) != null) {
            endTime = TimingAction.getStartTime((FlowNode)lastNode);
        }
        long l = startTime = firstNode instanceof FlowStartNode ? run.getStartTimeInMillis() : TimingAction.getStartTime((FlowNode)firstNode);
        if (after == null && exec.isComplete()) {
            endTime = run.getDuration() + run.getStartTimeInMillis();
        }
        return new TimingInfo(endTime - startTime, Math.min(Math.abs(internalPauseDuration), endTime - startTime), startTime);
    }

    @CheckForNull
    public static TimingInfo computeOverallParallelTiming(@Nonnull WorkflowRun run, @Nonnull Map<String, TimingInfo> branchTimings, @Nonnull FlowNode parallelStart, @CheckForNull FlowNode parallelEnd) {
        long overallDuration = 0L;
        long maxPause = 0L;
        boolean isIncomplete = parallelEnd == null || run.isBuilding();
        for (TimingInfo t : branchTimings.values()) {
            maxPause = Math.max(maxPause, t.getPauseDurationMillis());
            if (!isIncomplete) continue;
            overallDuration = Math.max(overallDuration, t.getTotalDurationMillis());
        }
        long start = TimingAction.getStartTime((FlowNode)parallelStart);
        if (!isIncomplete) {
            overallDuration = TimingAction.getStartTime((FlowNode)parallelEnd) - start;
        }
        return new TimingInfo(overallDuration, maxPause, start);
    }

    @Nonnull
    public static Map<String, TimingInfo> computeParallelBranchTimings(@Nonnull WorkflowRun run, @Nonnull FlowNode parallelStart, @Nonnull List<BlockStartNode> branchStarts, @Nonnull List<FlowNode> branchEnds, @CheckForNull FlowNode parallelEnd, @Nonnull long[] pauseDurations) {
        StatusAndTiming.verifySameRun(run, branchStarts.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, branchEnds.toArray(new FlowNode[0]));
        if (branchStarts.size() != branchEnds.size()) {
            throw new IllegalArgumentException("Mismatched start and stop node counts: " + branchStarts.size() + "," + branchEnds.size());
        }
        if (branchStarts.size() != pauseDurations.length) {
            throw new IllegalArgumentException("Mismatched node count and pause duration array: " + branchStarts.size() + "," + pauseDurations.length);
        }
        HashMap<String, TimingInfo> timings = new HashMap<String, TimingInfo>();
        for (int i = 0; i < branchEnds.size(); ++i) {
            BlockStartNode start = branchStarts.get(i);
            FlowNode end = branchEnds.get(i);
            if (end instanceof BlockEndNode && start != ((BlockEndNode)end).getStartNode()) {
                throw new IllegalArgumentException("Mismatched parallel branch start/end nodes: " + start.getId() + ',' + end.getId());
            }
            ThreadNameAction branchName = (ThreadNameAction)start.getAction(ThreadNameAction.class);
            assert (branchName != null);
            timings.put(branchName.getThreadName(), StatusAndTiming.computeChunkTiming(run, pauseDurations[i], (FlowNode)start, end, parallelEnd));
        }
        return timings;
    }

    @Nonnull
    public static Map<String, GenericStatus> computeBranchStatuses(@Nonnull WorkflowRun run, @Nonnull ParallelMemoryFlowChunk parallel) {
        Map branches = parallel.getBranches();
        ArrayList<BlockStartNode> starts = new ArrayList<BlockStartNode>(branches.size());
        ArrayList<FlowNode> ends = new ArrayList<FlowNode>(branches.size());
        for (MemoryFlowChunk chunk : branches.values()) {
            starts.add((BlockStartNode)chunk.getFirstNode());
            ends.add(chunk.getLastNode());
        }
        return StatusAndTiming.computeBranchStatuses(run, parallel.getFirstNode(), starts, ends, parallel.getLastNode());
    }

    @Nonnull
    public static Map<String, GenericStatus> computeBranchStatuses(@Nonnull WorkflowRun run, @Nonnull FlowNode parallelStart, @Nonnull List<BlockStartNode> branchStarts, @Nonnull List<FlowNode> branchEnds, @CheckForNull FlowNode parallelEnd) {
        StatusAndTiming.verifySameRun(run, branchStarts.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, branchEnds.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, parallelStart, parallelEnd);
        if (branchStarts.size() != branchEnds.size()) {
            throw new IllegalArgumentException("Mismatched start and stop node counts: " + branchStarts.size() + "," + branchEnds.size());
        }
        HashMap<String, GenericStatus> statusMappings = new HashMap<String, GenericStatus>();
        for (int i = 0; i < branchEnds.size(); ++i) {
            BlockStartNode start = branchStarts.get(i);
            FlowNode end = branchEnds.get(i);
            if (end instanceof BlockEndNode && start != ((BlockEndNode)end).getStartNode()) {
                throw new IllegalArgumentException("Mismatched parallel branch start/end nodes: " + start.getId() + ',' + end.getId());
            }
            ThreadNameAction branchName = (ThreadNameAction)start.getAction(ThreadNameAction.class);
            assert (branchName != null);
            statusMappings.put(branchName.getThreadName(), StatusAndTiming.computeChunkStatus(run, parallelStart, (FlowNode)start, end, parallelEnd));
        }
        return statusMappings;
    }

    @CheckForNull
    public static GenericStatus condenseStatus(@Nonnull Collection<GenericStatus> statuses) {
        if (statuses.isEmpty()) {
            return null;
        }
        return Collections.max(statuses);
    }

    @Restricted(value={DoNotUse.class})
    public static void printNodes(@Nonnull WorkflowRun run, boolean showTiming, boolean showActions) {
        long runStartTime = run.getStartTimeInMillis();
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return;
        }
        DepthFirstScanner scanner = new DepthFirstScanner();
        List sorted = scanner.filteredNodes((Collection)exec.getCurrentHeads(), Predicates.alwaysTrue());
        Collections.sort(sorted, new Comparator<FlowNode>(){

            @Override
            public int compare(FlowNode node1, FlowNode node2) {
                int node2Iota;
                int node1Iota = this.parseIota(node1);
                if (node1Iota < (node2Iota = this.parseIota(node2))) {
                    return -1;
                }
                if (node1Iota > node2Iota) {
                    return 1;
                }
                return 0;
            }

            private int parseIota(FlowNode node) {
                try {
                    return Integer.parseInt(node.getId());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        System.out.println("Node dump follows, format:");
        System.out.println("[ID]{parent,ids}(millisSinceStartOfRun) flowNodeClassName stepDisplayName [st=startId if a block end node]");
        System.out.println("Action format: ");
        System.out.println("\t- actionClassName actionDisplayName");
        System.out.println("------------------------------------------------------------------------------------------");
        for (FlowNode node : sorted) {
            StringBuilder formatted = new StringBuilder();
            formatted.append('[').append(node.getId()).append(']');
            formatted.append('{').append(StringUtils.join((Collection)node.getParentIds(), (char)',')).append('}');
            if (showTiming) {
                formatted.append('(');
                if (node.getAction(TimingAction.class) != null) {
                    formatted.append(TimingAction.getStartTime((FlowNode)node) - runStartTime);
                } else {
                    formatted.append("N/A");
                }
                formatted.append(')');
            }
            formatted.append(node.getClass().getSimpleName()).append(' ').append(node.getDisplayName());
            if (node instanceof BlockEndNode) {
                formatted.append("  [st=").append(((BlockEndNode)node).getStartNode().getId()).append(']');
            }
            if (showActions) {
                for (Action a : node.getActions()) {
                    if (a instanceof TimingAction) continue;
                    formatted.append("\n  -").append(a.getClass().getSimpleName()).append(' ').append(a.getDisplayName());
                }
            }
            System.out.println(formatted);
        }
        System.out.println("------------------------------------------------------------------------------------------");
    }
}

