/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.pipelinegraphanalysis;

import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Action;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.QueueItemAction;
import org.jenkinsci.plugins.workflow.actions.TagsAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graph.FlowStartNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.ParallelMemoryFlowChunk;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class StatusAndTiming {
    public static final StatusApiVersion API_V1 = new StatusApiVersion(1, EnumSet.of(GenericStatus.NOT_EXECUTED, new GenericStatus[]{GenericStatus.SUCCESS, GenericStatus.UNSTABLE, GenericStatus.IN_PROGRESS, GenericStatus.FAILURE, GenericStatus.ABORTED, GenericStatus.PAUSED_PENDING_INPUT}));
    public static final StatusApiVersion API_V2;
    public static final StatusApiVersion CURRENT_API_VERSION;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Non-final for access from the Groovy script console")
    public static boolean DISABLE_WARNING_ACTION_LOOKUP;

    public static GenericStatus coerceStatusApi(GenericStatus rawStatus, StatusApiVersion desiredVersion) {
        if (rawStatus == GenericStatus.QUEUED && desiredVersion.equals(API_V1)) {
            return GenericStatus.IN_PROGRESS;
        }
        return rawStatus;
    }

    public static void verifySameRun(@NonNull WorkflowRun run, FlowNode ... nodes) throws IllegalArgumentException {
        if (nodes == null || nodes.length == 0) {
            return;
        }
        FlowExecution exec = run.getExecution();
        int i = 0;
        for (FlowNode n : nodes) {
            if (n != null && n.getExecution() != exec) {
                throw new IllegalArgumentException("FlowNode not part of the same execution found, at index " + i + " with ID " + n.getId());
            }
            ++i;
        }
    }

    public static boolean isPendingInput(WorkflowRun run) {
        InputAction inputAction = (InputAction)run.getAction(InputAction.class);
        if (inputAction != null) {
            List executions;
            try {
                executions = inputAction.getExecutions();
            }
            catch (InterruptedException | TimeoutException ex) {
                try {
                    executions = inputAction.getExecutions();
                }
                catch (InterruptedException | TimeoutException ex2) {
                    executions = null;
                }
            }
            return executions != null && !executions.isEmpty();
        }
        return false;
    }

    @Deprecated
    @CheckForNull
    public static GenericStatus computeChunkStatus(@NonNull WorkflowRun run, @NonNull MemoryFlowChunk chunk) {
        GenericStatus newStatusEnum = StatusAndTiming.computeChunkStatus2(run, chunk);
        return StatusAndTiming.coerceStatusApi(newStatusEnum, API_V1);
    }

    @CheckForNull
    public static GenericStatus computeChunkStatus2(@NonNull WorkflowRun run, @NonNull MemoryFlowChunk chunk) {
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return null;
        }
        if (chunk instanceof ParallelMemoryFlowChunk) {
            ParallelMemoryFlowChunk par = (ParallelMemoryFlowChunk)chunk;
            return StatusAndTiming.condenseStatus(StatusAndTiming.computeBranchStatuses2(run, par).values());
        }
        return StatusAndTiming.computeChunkStatus2(run, chunk.getNodeBefore(), chunk.getFirstNode(), chunk.getLastNode(), chunk.getNodeAfter());
    }

    @Deprecated
    @CheckForNull
    public static GenericStatus computeChunkStatus(@NonNull WorkflowRun run, @CheckForNull FlowNode before, @NonNull FlowNode firstNode, @NonNull FlowNode lastNode, @CheckForNull FlowNode after) {
        GenericStatus newStatusEnum = StatusAndTiming.computeChunkStatus2(run, before, firstNode, lastNode, after);
        return newStatusEnum == GenericStatus.QUEUED ? GenericStatus.IN_PROGRESS : newStatusEnum;
    }

    @CheckForNull
    public static GenericStatus computeChunkStatus2(@NonNull WorkflowRun run, @CheckForNull FlowNode before, @NonNull FlowNode firstNode, @NonNull FlowNode lastNode, @CheckForNull FlowNode after) {
        boolean isLastChunk;
        FlowExecution exec = run.getExecution();
        StatusAndTiming.verifySameRun(run, before, firstNode, lastNode, after);
        if (exec == null) {
            return null;
        }
        if (!NotExecutedNodeAction.isExecuted((FlowNode)lastNode) || StatusAndTiming.wasStageSkippedForConditional(firstNode)) {
            return GenericStatus.NOT_EXECUTED;
        }
        boolean bl = isLastChunk = after == null || exec.isCurrentHead(lastNode);
        if (isLastChunk) {
            if (run.isBuilding()) {
                BlockStartNode start;
                if (exec.getCurrentHeads().size() > 1 && lastNode instanceof BlockEndNode && (start = ((BlockEndNode)lastNode).getStartNode()).getAction(ThreadNameAction.class) != null) {
                    return lastNode.getError() == null ? GenericStatus.SUCCESS : GenericStatus.FAILURE;
                }
                if (lastNode instanceof StepStartNode && lastNode.getAction(QueueItemAction.class) != null) {
                    QueueItemAction.QueueState queueState = QueueItemAction.getNodeState((FlowNode)lastNode);
                    if (queueState == QueueItemAction.QueueState.QUEUED) {
                        return GenericStatus.QUEUED;
                    }
                    if (queueState == QueueItemAction.QueueState.CANCELLED) {
                        return GenericStatus.ABORTED;
                    }
                    return GenericStatus.IN_PROGRESS;
                }
                PauseAction pauseAction = (PauseAction)lastNode.getAction(PauseAction.class);
                if (StatusAndTiming.isPendingInput(run) && pauseAction != null && pauseAction.getCause().equals("Input")) {
                    return GenericStatus.PAUSED_PENDING_INPUT;
                }
                return GenericStatus.IN_PROGRESS;
            }
            Result r = run.getResult();
            return GenericStatus.fromResult(r);
        }
        ErrorAction err = lastNode.getError();
        if (err != null) {
            Throwable rootCause = err.getError();
            if (rootCause instanceof FlowInterruptedException) {
                FlowInterruptedException flowInterruptedException = (FlowInterruptedException)rootCause;
                return GenericStatus.fromResult(flowInterruptedException.getResult());
            }
            return GenericStatus.FAILURE;
        }
        WarningAction warning = StatusAndTiming.findWorstWarningBetween(firstNode, lastNode);
        if (warning != null) {
            return GenericStatus.fromResult(warning.getResult());
        }
        return GenericStatus.SUCCESS;
    }

    @CheckForNull
    public static WarningAction findWorstWarningBetween(@NonNull FlowNode start, @NonNull FlowNode end) {
        if (DISABLE_WARNING_ACTION_LOOKUP) {
            return null;
        }
        DepthFirstScanner scanner = new DepthFirstScanner();
        if (!scanner.setup(end, Collections.singletonList(start))) {
            return null;
        }
        return StreamSupport.stream(scanner.spliterator(), false).map(node -> (WarningAction)node.getPersistentAction(WarningAction.class)).filter(Objects::nonNull).max(Comparator.comparing(warning -> warning.getResult().ordinal)).orElse(null);
    }

    private static boolean wasStageSkippedForConditional(FlowNode node) {
        TagsAction tags = (TagsAction)node.getAction(TagsAction.class);
        return tags != null && StageStatus.getSkippedForConditional().equals(tags.getTagValue("STAGE_STATUS"));
    }

    @CheckForNull
    public static TimingInfo computeChunkTiming(@NonNull WorkflowRun run, long internalPauseDuration, @NonNull MemoryFlowChunk chunk) {
        return StatusAndTiming.computeChunkTiming(run, internalPauseDuration, chunk.getFirstNode(), chunk.getLastNode(), chunk.getNodeAfter());
    }

    @CheckForNull
    public static TimingInfo computeChunkTiming(@NonNull WorkflowRun run, long internalPauseDuration, @NonNull FlowNode firstNode, @NonNull FlowNode lastNode, @CheckForNull FlowNode after) {
        long startTime;
        BlockEndNode blockEndNode;
        BlockStartNode start;
        long endTime;
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return null;
        }
        if (!NotExecutedNodeAction.isExecuted((FlowNode)lastNode)) {
            return new TimingInfo(0L, 0L, 0L);
        }
        StatusAndTiming.verifySameRun(run, firstNode, lastNode, after);
        long l = endTime = after != null ? TimingAction.getStartTime((FlowNode)after) : System.currentTimeMillis();
        if (lastNode instanceof BlockEndNode && (start = (blockEndNode = (BlockEndNode)lastNode).getStartNode()).getAction(ThreadNameAction.class) != null) {
            endTime = TimingAction.getStartTime((FlowNode)lastNode);
        }
        long l2 = startTime = firstNode instanceof FlowStartNode ? run.getStartTimeInMillis() : TimingAction.getStartTime((FlowNode)firstNode);
        if (after == null && exec.isComplete()) {
            endTime = run.getDuration() + run.getStartTimeInMillis();
        }
        return new TimingInfo(endTime - startTime, Math.min(Math.abs(internalPauseDuration), endTime - startTime), startTime);
    }

    @CheckForNull
    public static TimingInfo computeOverallParallelTiming(@NonNull WorkflowRun run, @NonNull Map<String, TimingInfo> branchTimings, @NonNull FlowNode parallelStart, @CheckForNull FlowNode parallelEnd) {
        long overallDuration = 0L;
        long maxPause = 0L;
        boolean isIncomplete = parallelEnd == null || run.isBuilding();
        for (TimingInfo t : branchTimings.values()) {
            maxPause = Math.max(maxPause, t.getPauseDurationMillis());
            if (!isIncomplete) continue;
            overallDuration = Math.max(overallDuration, t.getTotalDurationMillis());
        }
        long start = TimingAction.getStartTime((FlowNode)parallelStart);
        if (!isIncomplete) {
            overallDuration = TimingAction.getStartTime((FlowNode)parallelEnd) - start;
        }
        return new TimingInfo(overallDuration, maxPause, start);
    }

    @NonNull
    public static Map<String, TimingInfo> computeParallelBranchTimings(@NonNull WorkflowRun run, @NonNull FlowNode parallelStart, @NonNull List<BlockStartNode> branchStarts, @NonNull List<FlowNode> branchEnds, @CheckForNull FlowNode parallelEnd, @NonNull long[] pauseDurations) {
        StatusAndTiming.verifySameRun(run, branchStarts.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, branchEnds.toArray(new FlowNode[0]));
        if (branchStarts.size() != branchEnds.size()) {
            throw new IllegalArgumentException("Mismatched start and stop node counts: " + branchStarts.size() + "," + branchEnds.size());
        }
        if (branchStarts.size() != pauseDurations.length) {
            throw new IllegalArgumentException("Mismatched node count and pause duration array: " + branchStarts.size() + "," + pauseDurations.length);
        }
        HashMap<String, TimingInfo> timings = new HashMap<String, TimingInfo>();
        for (int i = 0; i < branchEnds.size(); ++i) {
            BlockEndNode blockEndNode;
            BlockStartNode start = branchStarts.get(i);
            FlowNode end = branchEnds.get(i);
            if (end instanceof BlockEndNode && start != (blockEndNode = (BlockEndNode)end).getStartNode()) {
                throw new IllegalArgumentException("Mismatched parallel branch start/end nodes: " + start.getId() + "," + end.getId());
            }
            ThreadNameAction branchName = (ThreadNameAction)start.getAction(ThreadNameAction.class);
            assert (branchName != null);
            timings.put(branchName.getThreadName(), StatusAndTiming.computeChunkTiming(run, pauseDurations[i], (FlowNode)start, end, parallelEnd));
        }
        return timings;
    }

    private static Map<String, GenericStatus> coerceStatusMap(Map<String, GenericStatus> newStatusMap) {
        HashMap<String, GenericStatus> coercedVals = new HashMap<String, GenericStatus>(newStatusMap.size());
        for (Map.Entry<String, GenericStatus> oldEntry : newStatusMap.entrySet()) {
            coercedVals.put(oldEntry.getKey(), StatusAndTiming.coerceStatusApi(oldEntry.getValue(), API_V1));
        }
        return coercedVals;
    }

    @Deprecated
    @NonNull
    public static Map<String, GenericStatus> computeBranchStatuses(@NonNull WorkflowRun run, @NonNull ParallelMemoryFlowChunk parallel) {
        return StatusAndTiming.coerceStatusMap(StatusAndTiming.computeBranchStatuses2(run, parallel));
    }

    @NonNull
    public static Map<String, GenericStatus> computeBranchStatuses2(@NonNull WorkflowRun run, @NonNull ParallelMemoryFlowChunk parallel) {
        Map branches = parallel.getBranches();
        ArrayList<BlockStartNode> starts = new ArrayList<BlockStartNode>(branches.size());
        ArrayList<FlowNode> ends = new ArrayList<FlowNode>(branches.size());
        for (MemoryFlowChunk chunk : branches.values()) {
            starts.add((BlockStartNode)chunk.getFirstNode());
            ends.add(chunk.getLastNode());
        }
        return StatusAndTiming.computeBranchStatuses2(run, parallel.getFirstNode(), starts, ends, parallel.getLastNode());
    }

    @Deprecated
    @NonNull
    public static Map<String, GenericStatus> computeBranchStatuses(@NonNull WorkflowRun run, @NonNull FlowNode parallelStart, @NonNull List<BlockStartNode> branchStarts, @NonNull List<FlowNode> branchEnds, @CheckForNull FlowNode parallelEnd) {
        return StatusAndTiming.coerceStatusMap(StatusAndTiming.computeBranchStatuses2(run, parallelStart, branchStarts, branchEnds, parallelEnd));
    }

    @NonNull
    public static Map<String, GenericStatus> computeBranchStatuses2(@NonNull WorkflowRun run, @NonNull FlowNode parallelStart, @NonNull List<BlockStartNode> branchStarts, @NonNull List<FlowNode> branchEnds, @CheckForNull FlowNode parallelEnd) {
        StatusAndTiming.verifySameRun(run, branchStarts.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, branchEnds.toArray(new FlowNode[0]));
        StatusAndTiming.verifySameRun(run, parallelStart, parallelEnd);
        if (branchStarts.size() != branchEnds.size()) {
            throw new IllegalArgumentException("Mismatched start and stop node counts: " + branchStarts.size() + "," + branchEnds.size());
        }
        HashMap<String, GenericStatus> statusMappings = new HashMap<String, GenericStatus>();
        for (int i = 0; i < branchEnds.size(); ++i) {
            BlockEndNode blockEndNode;
            BlockStartNode start = branchStarts.get(i);
            FlowNode end = branchEnds.get(i);
            if (end instanceof BlockEndNode && start != (blockEndNode = (BlockEndNode)end).getStartNode()) {
                throw new IllegalArgumentException("Mismatched parallel branch start/end nodes: " + start.getId() + "," + end.getId());
            }
            ThreadNameAction branchName = (ThreadNameAction)start.getAction(ThreadNameAction.class);
            assert (branchName != null);
            statusMappings.put(branchName.getThreadName(), StatusAndTiming.computeChunkStatus2(run, parallelStart, (FlowNode)start, end, parallelEnd));
        }
        return statusMappings;
    }

    @CheckForNull
    public static GenericStatus condenseStatus(@NonNull Collection<GenericStatus> statuses) {
        if (statuses.isEmpty()) {
            return null;
        }
        return Collections.max(statuses);
    }

    @Restricted(value={DoNotUse.class})
    public static void printNodes(@NonNull WorkflowRun run, boolean showTiming, boolean showActions) {
        long runStartTime = run.getStartTimeInMillis();
        FlowExecution exec = run.getExecution();
        if (exec == null) {
            return;
        }
        DepthFirstScanner scanner = new DepthFirstScanner();
        List sorted = scanner.filteredNodes((Collection)exec.getCurrentHeads(), Predicates.alwaysTrue());
        sorted.sort(new Comparator<FlowNode>(){

            @Override
            public int compare(FlowNode node1, FlowNode node2) {
                int node2Iota;
                int node1Iota = this.parseIota(node1);
                if (node1Iota < (node2Iota = this.parseIota(node2))) {
                    return -1;
                }
                if (node1Iota > node2Iota) {
                    return 1;
                }
                return 0;
            }

            private int parseIota(FlowNode node) {
                try {
                    return Integer.parseInt(node.getId());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        System.out.println("Node dump follows, format:");
        System.out.println("[ID]{parent,ids}(millisSinceStartOfRun) flowNodeClassName stepDisplayName [st=startId if a block end node]");
        System.out.println("Action format: ");
        System.out.println("\t- actionClassName actionDisplayName");
        System.out.println("------------------------------------------------------------------------------------------");
        Function<FlowNode, String> flowNodeToId = input -> input != null ? input.getId() : null;
        for (FlowNode node : sorted) {
            StringBuilder formatted = new StringBuilder();
            formatted.append('[').append(node.getId()).append(']');
            formatted.append('{').append(StringUtils.join((Collection)node.getParents().stream().map(flowNodeToId).collect(Collectors.toList()), (char)',')).append('}');
            if (showTiming) {
                formatted.append('(');
                if (node.getAction(TimingAction.class) != null) {
                    formatted.append(TimingAction.getStartTime((FlowNode)node) - runStartTime);
                } else {
                    formatted.append("N/A");
                }
                formatted.append(')');
            }
            formatted.append(node.getClass().getSimpleName()).append(' ').append(node.getDisplayName());
            if (node instanceof BlockEndNode) {
                BlockEndNode blockEndNode = (BlockEndNode)node;
                formatted.append("  [st=").append(blockEndNode.getStartNode().getId()).append(']');
            }
            if (showActions) {
                for (Action a : node.getActions()) {
                    if (a instanceof TimingAction) continue;
                    formatted.append("\n  -").append(a.getClass().getSimpleName()).append(' ').append(a.getDisplayName());
                }
            }
            System.out.println(formatted);
        }
        System.out.println("------------------------------------------------------------------------------------------");
    }

    static {
        CURRENT_API_VERSION = API_V2 = new StatusApiVersion(2, EnumSet.copyOf(Sets.union(StatusAndTiming.API_V1.allowedStatuses, Collections.singleton(GenericStatus.QUEUED))));
        DISABLE_WARNING_ACTION_LOOKUP = Boolean.getBoolean(StatusAndTiming.class.getName() + ".DISABLE_WARNING_ACTION_LOOKUP");
    }

    public static final class StatusApiVersion {
        private final int version;
        final Set<GenericStatus> allowedStatuses;

        public int getVersion() {
            return this.version;
        }

        public Set<GenericStatus> getAllowedStatuses() {
            return this.allowedStatuses;
        }

        StatusApiVersion(int version, EnumSet<GenericStatus> allowedStatuses) {
            this.version = version;
            this.allowedStatuses = Sets.immutableEnumSet(allowedStatuses);
        }
    }
}

