/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.fs;

import hudson.remoting.VirtualChannel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import jenkins.MasterToSlaveFileCallable;

public class ComputeHashCallable
extends MasterToSlaveFileCallable<String> {
    private final String hashAlgorithm;

    public ComputeHashCallable(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public String invoke(File file, VirtualChannel virtualChannel) throws IOException {
        if (file.exists() && file.isFile()) {
            try {
                return this.hashOfFile(file);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return null;
    }

    public String hashOfFile(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance(this.hashAlgorithm);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                messageDigest.update(buffer, 0, read);
            }
        }
        return this.byteToHex(messageDigest.digest());
    }

    private String byteToHex(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }
}

