/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.jenkins;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.ComboBoxModel;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.pipeline.utility.steps.Messages;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NodesByLabelStep
extends Step {
    private final String label;
    private boolean offline = false;

    @DataBoundConstructor
    public NodesByLabelStep(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isOffline() {
        return this.offline;
    }

    @DataBoundSetter
    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.label, this.offline, context);
    }

    public static class Execution
    extends SynchronousStepExecution<List<String>> {
        private static final long serialVersionUID = 1L;
        private final String label;
        private final boolean includeOffline;

        Execution(String label, boolean includeOffline, StepContext context) {
            super(context);
            this.label = label;
            this.includeOffline = includeOffline;
        }

        protected List<String> run() throws Exception {
            Label aLabel = Label.get((String)this.label);
            Set nodeSet = aLabel != null ? aLabel.getNodes() : Collections.emptySet();
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            assert (listener != null);
            PrintStream logger = listener.getLogger();
            ArrayList<String> nodes = new ArrayList<String>();
            if (nodeSet != null && !nodeSet.isEmpty()) {
                for (Node node : nodeSet) {
                    Computer computer = node.toComputer();
                    if (!this.includeOffline && (computer == null || computer.isOffline())) continue;
                    nodes.add(node.getNodeName());
                }
            }
            if (nodes.isEmpty()) {
                logger.println("Could not find any nodes with '" + this.label + "' label");
            } else {
                logger.println("Found a total of " + nodes.size() + " nodes with the '" + this.label + "' label");
            }
            return nodes;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "nodesByLabel";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.NodesByLabelStep_displayName();
        }

        public ComboBoxModel doFillLabelItems() {
            ComboBoxModel cbm = new ComboBoxModel();
            Set labels = Jenkins.get().getLabels();
            for (Label label : labels) {
                cbm.add((Object)label.getDisplayName());
            }
            return cbm;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

