/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.trait;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.trait.SCMNavigatorContext;
import jenkins.scm.api.trait.SCMNavigatorTrait;
import jenkins.scm.api.trait.SCMNavigatorTraitDescriptor;
import jenkins.scm.api.trait.SCMSourcePrefilter;
import jenkins.scm.impl.trait.Messages;
import jenkins.scm.impl.trait.Selection;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class WildcardSCMSourceFilterTrait
extends SCMNavigatorTrait {
    @NonNull
    private final String includes;
    @NonNull
    private final String excludes;

    @DataBoundConstructor
    public WildcardSCMSourceFilterTrait(String includes, String excludes) {
        this.includes = StringUtils.defaultIfBlank((String)includes, (String)"*");
        this.excludes = StringUtils.defaultIfBlank((String)excludes, (String)"");
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    @Override
    protected void decorateContext(SCMNavigatorContext<?, ?> context) {
        context.withPrefilter(new SCMSourcePrefilter(){

            @Override
            public boolean isExcluded(@NonNull SCMNavigator source, @NonNull String projectName) {
                return !Pattern.matches(WildcardSCMSourceFilterTrait.this.getPattern(WildcardSCMSourceFilterTrait.this.getIncludes()), projectName) || Pattern.matches(WildcardSCMSourceFilterTrait.this.getPattern(WildcardSCMSourceFilterTrait.this.getExcludes()), projectName);
            }
        });
    }

    private String getPattern(String branches) {
        StringBuilder quotedBranches = new StringBuilder();
        for (String wildcard : branches.split(" ")) {
            StringBuilder quotedBranch = new StringBuilder();
            for (String branch : wildcard.split("(?=[*])|(?<=[*])")) {
                if (branch.equals("*")) {
                    quotedBranch.append(".*");
                    continue;
                }
                if (branch.isEmpty()) continue;
                quotedBranch.append(Pattern.quote(branch));
            }
            if (quotedBranches.length() > 0) {
                quotedBranches.append("|");
            }
            quotedBranches.append((CharSequence)quotedBranch);
        }
        return quotedBranches.toString();
    }

    @Symbol(value={"sourceWildcardFilter"})
    @Extension
    @Selection
    public static class DescriptorImpl
    extends SCMNavigatorTraitDescriptor {
        public String getDisplayName() {
            return Messages.WildcardSCMSourceFilterTrait_DisplayName();
        }
    }
}

