/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.util.EnumSet;
import java.util.Set;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.mock.MockSCMSourceRequest;

public class MockSCMSourceContext
extends SCMSourceContext<MockSCMSourceContext, MockSCMSourceRequest> {
    private boolean needsBranches;
    private boolean needsTags;
    private boolean needsChangeRequests;
    private Set<ChangeRequestCheckoutStrategy> checkoutStrategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);

    public MockSCMSourceContext(MockSCMSource source, SCMSourceCriteria criteria, SCMHeadObserver observer) {
        super(criteria, observer);
    }

    public MockSCMSourceContext withBranches(boolean included) {
        this.needsBranches = this.needsBranches || included;
        return this;
    }

    public MockSCMSourceContext withTags(boolean included) {
        this.needsTags = this.needsTags || included;
        return this;
    }

    public MockSCMSourceContext withChangeRequests(boolean included) {
        this.needsChangeRequests = this.needsChangeRequests || included;
        return this;
    }

    public boolean needsBranches() {
        return this.needsBranches;
    }

    public boolean needsTags() {
        return this.needsTags;
    }

    public boolean needsChangeRequests() {
        return this.needsChangeRequests;
    }

    public Set<ChangeRequestCheckoutStrategy> checkoutStrategies() {
        return this.checkoutStrategies;
    }

    public MockSCMSourceContext withCheckoutStrategies(Set<ChangeRequestCheckoutStrategy> checkoutStrategies) {
        this.checkoutStrategies.addAll(checkoutStrategies);
        return this;
    }

    @NonNull
    public MockSCMSourceRequest newRequest(@NonNull SCMSource source, @CheckForNull TaskListener listener) {
        return new MockSCMSourceRequest(source, this, listener);
    }
}

