/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import hudson.model.TaskListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.impl.mock.MockSCMSourceContext;

public class MockSCMSourceRequest
extends SCMSourceRequest {
    private final boolean fetchBranches;
    private final boolean fetchTags;
    private final boolean fetchChangeRequests;
    private final Set<ChangeRequestCheckoutStrategy> checkoutStrategies;

    MockSCMSourceRequest(SCMSource source, MockSCMSourceContext builder, TaskListener listener) {
        super(source, (SCMSourceContext)builder, listener);
        this.fetchBranches = builder.needsBranches();
        this.fetchTags = builder.needsTags();
        this.fetchChangeRequests = builder.needsChangeRequests();
        this.checkoutStrategies = builder.checkoutStrategies().isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(builder.checkoutStrategies()));
    }

    public boolean isFetchBranches() {
        return this.fetchBranches;
    }

    public boolean isFetchTags() {
        return this.fetchTags;
    }

    public boolean isFetchChangeRequests() {
        return this.fetchChangeRequests;
    }

    public Set<ChangeRequestCheckoutStrategy> getCheckoutStrategies() {
        return this.checkoutStrategies;
    }
}

