/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import hudson.Functions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.jenkinsci.plugins.scriptsecurity.sandbox.RejectedAccessException;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovyCallSiteSelector;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.EnumeratingWhitelist;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.StaticWhitelist;
import org.kohsuke.groovy.sandbox.GroovyInterceptor;

final class SandboxInterceptor
extends GroovyInterceptor {
    private final Whitelist whitelist;

    SandboxInterceptor(Whitelist whitelist) {
        this.whitelist = whitelist;
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.method(receiver, method, args);
        if (m == null) {
            if (receiver instanceof Number || receiver instanceof String && method.equals("plus")) {
                return super.onMethodCall(invoker, receiver, method, args);
            }
            Object[] selfArgs = new Object[args.length + 1];
            selfArgs[0] = receiver;
            System.arraycopy(args, 0, selfArgs, 1, args.length);
            if (GroovyCallSiteSelector.staticMethod(DefaultGroovyMethods.class, method, selfArgs) != null) {
                return this.onStaticCall(invoker, DefaultGroovyMethods.class, method, selfArgs);
            }
            try {
                receiver.getClass().getMethod("invokeMethod", String.class, Object.class);
                return this.onMethodCall(invoker, receiver, "invokeMethod", method, args);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RejectedAccessException("unclassified method " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + method + SandboxInterceptor.printArgumentTypes(args));
            }
        }
        if (this.whitelist.permitsMethod(m, receiver, args)) {
            return super.onMethodCall(invoker, receiver, method, args);
        }
        if (method.equals("invokeMethod") && args.length == 2 && args[0] instanceof String && args[1] instanceof Object[]) {
            throw StaticWhitelist.rejectMethod(m, EnumeratingWhitelist.getName(receiver.getClass()) + " " + args[0] + SandboxInterceptor.printArgumentTypes((Object[])args[1]));
        }
        throw StaticWhitelist.rejectMethod(m);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        Constructor<?> c = GroovyCallSiteSelector.constructor(receiver, args);
        if (c == null) {
            throw new RejectedAccessException("unclassified new " + EnumeratingWhitelist.getName(receiver) + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsConstructor(c, args)) {
            return super.onNewInstance(invoker, receiver, args);
        }
        throw StaticWhitelist.rejectNew(c);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        Method m = GroovyCallSiteSelector.staticMethod(receiver, method, args);
        if (m == null) {
            throw new RejectedAccessException("unclassified staticMethod " + EnumeratingWhitelist.getName(receiver) + " " + method + SandboxInterceptor.printArgumentTypes(args));
        }
        if (this.whitelist.permitsStaticMethod(m, args)) {
            return super.onStaticCall(invoker, receiver, method, args);
        }
        throw StaticWhitelist.rejectStaticMethod(m);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property, Object value) throws Throwable {
        Object[] propertyValueArgs;
        Method setPropertyMethod;
        if (receiver instanceof Script && !property.equals("binding") && !property.equals("metaClass")) {
            return super.onSetProperty(invoker, receiver, property, value);
        }
        Rejector rejector = null;
        final Field instanceField = GroovyCallSiteSelector.field(receiver, property);
        if (instanceField != null) {
            if (this.whitelist.permitsFieldSet(instanceField, receiver, value)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            rejector = new Rejector(){

                @Override
                public RejectedAccessException reject() {
                    return StaticWhitelist.rejectField(instanceField);
                }
            };
        }
        Object[] valueArg = new Object[]{value};
        String setter = "set" + Functions.capitalize((String)property);
        final Method setterMethod = GroovyCallSiteSelector.method(receiver, setter, valueArg);
        if (setterMethod != null) {
            if (this.whitelist.permitsMethod(setterMethod, receiver, valueArg)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setterMethod);
                    }
                };
            }
        }
        if ((setPropertyMethod = GroovyCallSiteSelector.method(receiver, "setProperty", propertyValueArgs = new Object[]{property, value})) != null) {
            if (this.whitelist.permitsMethod(setPropertyMethod, receiver, propertyValueArgs)) {
                return super.onSetProperty(invoker, receiver, property, value);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(setPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if (receiver instanceof Class) {
            Method staticSetterMethod;
            final Field staticField = GroovyCallSiteSelector.staticField((Class)receiver, property);
            if (staticField != null) {
                if (this.whitelist.permitsStaticFieldSet(staticField, value)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
            if ((staticSetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, setter, valueArg)) != null) {
                if (this.whitelist.permitsStaticMethod(staticSetterMethod, valueArg)) {
                    return super.onSetProperty(invoker, receiver, property, value);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticSetterMethod);
                        }
                    };
                }
            }
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, final Object receiver, final String property) throws Throwable {
        Object[] propertyArg;
        Method getPropertyMethod;
        String booleanGetter;
        Method booleanGetterMethod;
        MissingPropertyException mpe = null;
        if (receiver instanceof Script) {
            try {
                ((Script)receiver).getBinding().getVariable(property);
                return super.onGetProperty(invoker, receiver, property);
            }
            catch (MissingPropertyException x) {
                mpe = x;
            }
        }
        if (property.equals("length") && receiver.getClass().isArray()) {
            return super.onGetProperty(invoker, receiver, property);
        }
        Rejector rejector = null;
        final Field instanceField = GroovyCallSiteSelector.field(receiver, property);
        if (instanceField != null) {
            if (this.whitelist.permitsFieldGet(instanceField, receiver)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            rejector = new Rejector(){

                @Override
                public RejectedAccessException reject() {
                    return StaticWhitelist.rejectField(instanceField);
                }
            };
        }
        Object[] noArgs = new Object[]{};
        String getter = "get" + Functions.capitalize((String)property);
        final Method getterMethod = GroovyCallSiteSelector.method(receiver, getter, noArgs);
        if (getterMethod != null) {
            if (this.whitelist.permitsMethod(getterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getterMethod);
                    }
                };
            }
        }
        if ((booleanGetterMethod = GroovyCallSiteSelector.method(receiver, booleanGetter = "is" + Functions.capitalize((String)property), noArgs)) != null && booleanGetterMethod.getReturnType() == Boolean.TYPE) {
            if (this.whitelist.permitsMethod(booleanGetterMethod, receiver, noArgs)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(booleanGetterMethod);
                    }
                };
            }
        }
        if ((getPropertyMethod = GroovyCallSiteSelector.method(receiver, "getProperty", propertyArg = new Object[]{property})) != null) {
            if (this.whitelist.permitsMethod(getPropertyMethod, receiver, propertyArg)) {
                return super.onGetProperty(invoker, receiver, property);
            }
            if (rejector == null) {
                rejector = new Rejector(){

                    @Override
                    public RejectedAccessException reject() {
                        return StaticWhitelist.rejectMethod(getPropertyMethod, receiver.getClass().getName() + "." + property);
                    }
                };
            }
        }
        if (receiver instanceof Class) {
            Method staticBooleanGetterMethod;
            Method staticGetterMethod;
            final Field staticField = GroovyCallSiteSelector.staticField((Class)receiver, property);
            if (staticField != null) {
                if (this.whitelist.permitsStaticFieldGet(staticField)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticField(staticField);
                        }
                    };
                }
            }
            if ((staticGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, getter, noArgs)) != null) {
                if (this.whitelist.permitsStaticMethod(staticGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticGetterMethod);
                        }
                    };
                }
            }
            if ((staticBooleanGetterMethod = GroovyCallSiteSelector.staticMethod((Class)receiver, booleanGetter, noArgs)) != null && staticBooleanGetterMethod.getReturnType() == Boolean.TYPE) {
                if (this.whitelist.permitsStaticMethod(staticBooleanGetterMethod, noArgs)) {
                    return super.onGetProperty(invoker, receiver, property);
                }
                if (rejector == null) {
                    rejector = new Rejector(){

                        @Override
                        public RejectedAccessException reject() {
                            return StaticWhitelist.rejectStaticMethod(staticBooleanGetterMethod);
                        }
                    };
                }
            }
        }
        if (mpe != null) {
            throw mpe;
        }
        throw rejector != null ? rejector.reject() : SandboxInterceptor.unclassifiedField(receiver, property);
    }

    private static RejectedAccessException unclassifiedField(Object receiver, String property) {
        return new RejectedAccessException("unclassified field " + EnumeratingWhitelist.getName(receiver.getClass()) + " " + property);
    }

    private static String printArgumentTypes(Object[] args) {
        StringBuilder b = new StringBuilder();
        for (Object arg : args) {
            b.append(' ');
            b.append(arg == null ? "null" : EnumeratingWhitelist.getName(arg.getClass()));
        }
        return b.toString();
    }

    private static interface Rejector {
        @Nonnull
        public RejectedAccessException reject();
    }
}

