/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.ACL;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptsecurity.sandbox.Whitelist;

public class AclAwareWhitelist
extends Whitelist {
    private final Whitelist unrestricted;
    private final Whitelist restricted;

    public AclAwareWhitelist(Whitelist unrestricted, Whitelist restricted) {
        this.unrestricted = unrestricted;
        this.restricted = restricted;
    }

    private static boolean authenticated() {
        return !ACL.SYSTEM2.equals(Jenkins.getAuthentication2());
    }

    @Override
    public boolean permitsMethod(@NonNull Method method, @NonNull Object receiver, @NonNull Object[] args) {
        return this.unrestricted.permitsMethod(method, receiver, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsMethod(method, receiver, args);
    }

    @Override
    public boolean permitsConstructor(@NonNull Constructor<?> constructor, @NonNull Object[] args) {
        return this.unrestricted.permitsConstructor(constructor, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsConstructor(constructor, args);
    }

    @Override
    public boolean permitsStaticMethod(@NonNull Method method, @NonNull Object[] args) {
        return this.unrestricted.permitsStaticMethod(method, args) || AclAwareWhitelist.authenticated() && this.restricted.permitsStaticMethod(method, args);
    }

    @Override
    public boolean permitsFieldGet(@NonNull Field field, @NonNull Object receiver) {
        return this.unrestricted.permitsFieldGet(field, receiver);
    }

    @Override
    public boolean permitsFieldSet(@NonNull Field field, @NonNull Object receiver, Object value) {
        return this.unrestricted.permitsFieldSet(field, receiver, value);
    }

    @Override
    public boolean permitsStaticFieldGet(@NonNull Field field) {
        return this.unrestricted.permitsStaticFieldGet(field);
    }

    @Override
    public boolean permitsStaticFieldSet(@NonNull Field field, Object value) {
        return this.unrestricted.permitsStaticFieldSet(field, value);
    }
}

