/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import com.google.common.primitives.Primitives;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.util.ReflectionUtils;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.jenkinsci.plugins.structs.describable.DescribableParameter;
import org.jenkinsci.plugins.structs.describable.Setter;
import org.jvnet.tiger_types.Types;
import org.kohsuke.stapler.ClassDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.lang.Klass;

public final class DescribableModel<T> {
    private final Class<T> type;
    private final Map<String, DescribableParameter> parameters = new LinkedHashMap<String, DescribableParameter>();
    private final Map<String, DescribableParameter> parametersView = Collections.unmodifiableMap(this.parameters);
    private final Constructor<T> constructor;
    private final String[] constructorParamNames;
    public static final String CLAZZ = "$class";
    private static final Logger LOGGER = Logger.getLogger(DescribableModel.class.getName());

    public DescribableModel(Class<T> clazz) {
        this.type = clazz;
        this.constructorParamNames = this.type == ParametersDefinitionProperty.class ? new String[]{"parameterDefinitions"} : new ClassDescriptor(this.type, new Class[0]).loadConstructorParamNames();
        this.constructor = this.findConstructor(this.constructorParamNames.length);
        Type[] types = this.constructor.getGenericParameterTypes();
        for (int i = 0; i < this.constructorParamNames.length; ++i) {
            this.addParameter(this.parameters, types[i], this.constructorParamNames[i], null);
        }
        TreeMap<String, DescribableParameter> rest = new TreeMap<String, DescribableParameter>();
        for (Class<T> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(DataBoundSetter.class)) continue;
                this.addParameter(rest, field.getGenericType(), field.getName(), Setter.create(field));
            }
            for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
                if (!accessibleObject.isAnnotationPresent(DataBoundSetter.class)) continue;
                Type[] parameterTypes = ((Method)accessibleObject).getGenericParameterTypes();
                if (!((Method)accessibleObject).getName().startsWith("set") || parameterTypes.length != 1) {
                    throw new IllegalStateException(accessibleObject + " cannot be a @DataBoundSetter");
                }
                this.addParameter(rest, ((Method)accessibleObject).getGenericParameterTypes()[0], Introspector.decapitalize(((Method)accessibleObject).getName().substring(3)), Setter.create((Method)accessibleObject));
            }
        }
        this.parameters.putAll(rest);
    }

    private void addParameter(Map<String, DescribableParameter> props, Type type, String name, Setter setter) {
        props.put(name, new DescribableParameter(this, type, name, setter));
    }

    public Class<T> getType() {
        return this.type;
    }

    public Collection<DescribableParameter> getParameters() {
        return this.parametersView.values();
    }

    public DescribableParameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public String getDisplayName() {
        for (Descriptor d : DescribableModel.getDescriptorList()) {
            if (d.clazz != this.type) continue;
            return d.getDisplayName();
        }
        return this.type.getSimpleName();
    }

    public T instantiate(Map<String, ?> arguments) throws Exception {
        Object[] args = this.buildArguments(arguments, this.constructor.getGenericParameterTypes(), this.constructorParamNames, true);
        T o = this.constructor.newInstance(args);
        this.injectSetters(o, arguments);
        return o;
    }

    private Constructor<T> findConstructor(int length) {
        Constructor<?>[] ctrs;
        try {
            if (this.type == ParametersDefinitionProperty.class && length == 1) {
                return ParametersDefinitionProperty.class.getConstructor(List.class);
            }
        }
        catch (NoSuchMethodException x) {
            throw new AssertionError((Object)x);
        }
        for (Constructor<?> c : ctrs = this.type.getConstructors()) {
            if (c.getAnnotation(DataBoundConstructor.class) == null) continue;
            if (c.getParameterTypes().length != length) {
                throw new IllegalArgumentException(c + " has @DataBoundConstructor but it doesn't match with your .stapler file. Try clean rebuild");
            }
            return c;
        }
        for (Constructor<?> c : ctrs) {
            if (c.getParameterTypes().length != length) continue;
            return c;
        }
        throw new IllegalArgumentException(this.type + " does not have a constructor with " + length + " arguments");
    }

    private Object[] buildArguments(Map<String, ?> bag, Type[] types, String[] names, boolean callEvenIfNoArgs) throws Exception {
        assert (names.length == types.length);
        Object[] args = new Object[names.length];
        boolean hasArg = callEvenIfNoArgs;
        for (int i = 0; i < args.length; ++i) {
            String name = names[i];
            hasArg |= bag.containsKey(name);
            Object a = bag.get(name);
            Type type = types[i];
            if (a != null) {
                args[i] = this.coerce(this.type.getName() + "." + name, type, a);
                continue;
            }
            if (!(type instanceof Class) || !((Class)type).isPrimitive()) continue;
            args[i] = ReflectionUtils.getVmDefaultValueForPrimitiveType((Class)((Class)type));
            if (args[i] != null || !callEvenIfNoArgs) continue;
            throw new UnsupportedOperationException("not yet handling @DataBoundConstructor default value of " + type + "; pass an explicit value for " + name);
        }
        return hasArg ? args : null;
    }

    private void injectSetters(Object o, Map<String, ?> arguments) throws Exception {
        for (DescribableParameter p : this.parameters.values()) {
            if (p.setter == null || !arguments.containsKey(p.getName())) continue;
            Object v = arguments.get(p.getName());
            p.setter.set(o, this.coerce(p.setter.getDisplayName(), p.getRawType(), v));
        }
    }

    private Object coerce(String context, Type type, Object o) throws Exception {
        Class erased = Types.erasure((Type)type);
        if (type instanceof Class) {
            o = ReflectionCache.getCachedClass((Class)erased).coerceArgument(o);
        }
        if (o instanceof List && Collection.class.isAssignableFrom(erased)) {
            return this.coerceList(context, Types.getTypeArgument((Type)Types.getBaseClass((Type)type, Collection.class), (int)0, Object.class), (List)o);
        }
        if (Primitives.wrap((Class)erased).isInstance(o)) {
            return o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            HashMap m = new HashMap();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                m.put((String)entry.getKey(), entry.getValue());
            }
            Class<?> clazz = this.resolveClass(erased, (String)m.remove(CLAZZ));
            return new DescribableModel(clazz).instantiate(m);
        }
        if (o instanceof String && erased.isEnum()) {
            return Enum.valueOf(erased.asSubclass(Enum.class), (String)o);
        }
        if (o instanceof String && erased == URL.class) {
            return new URL((String)o);
        }
        if (o instanceof String && (erased == Character.TYPE || erased == Character.class) && ((String)o).length() == 1) {
            return Character.valueOf(((String)o).charAt(0));
        }
        if (o instanceof List && erased.isArray()) {
            Class<?> componentType = erased.getComponentType();
            List<Object> list = this.coerceList(context, componentType, (List)o);
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        throw new ClassCastException(context + " expects " + type + " but received " + o.getClass());
    }

    private Class<?> resolveClass(Class base, String name) throws ClassNotFoundException {
        if (name == null) {
            if (Modifier.isAbstract(base.getModifiers())) {
                throw new UnsupportedOperationException("must specify $class with an implementation of " + base);
            }
            return base;
        }
        if (name.contains(".")) {
            Jenkins j = Jenkins.getInstance();
            ClassLoader loader = j != null ? j.getPluginManager().uberClassLoader : Thread.currentThread().getContextClassLoader();
            return Class.forName(name, true, loader);
        }
        Class<?> clazz = null;
        for (Class<?> c : DescribableModel.findSubtypes(base)) {
            if (!c.getSimpleName().equals(name)) continue;
            if (clazz != null) {
                throw new UnsupportedOperationException(name + " as a " + base + " could mean either " + clazz.getName() + " or " + c.getName());
            }
            clazz = c;
        }
        if (clazz == null) {
            throw new UnsupportedOperationException("no known implementation of " + base + " is named " + name);
        }
        return clazz;
    }

    private List<Object> coerceList(String context, Type type, List<?> list) throws Exception {
        ArrayList<Object> r = new ArrayList<Object>();
        for (Object elt : list) {
            r.add(this.coerce(context, type, elt));
        }
        return r;
    }

    static Set<Class<?>> findSubtypes(Class<?> supertype) {
        HashSet clazzes = new HashSet();
        for (Descriptor descriptor : DescribableModel.getDescriptorList()) {
            if (!supertype.isAssignableFrom(descriptor.clazz)) continue;
            clazzes.add(descriptor.clazz);
        }
        if (supertype == ParameterValue.class) {
            for (Class clazz : DescribableModel.findSubtypes(ParameterDefinition.class)) {
                String name = clazz.getName();
                if (!name.endsWith("Definition")) continue;
                try {
                    Class<?> c = clazz.getClassLoader().loadClass(name.replaceFirst("Definition$", "Value"));
                    if (!supertype.isAssignableFrom(c)) continue;
                    clazzes.add(c);
                }
                catch (ClassNotFoundException x) {}
            }
        }
        return clazzes;
    }

    private static List<? extends Descriptor> getDescriptorList() {
        Jenkins j = Jenkins.getInstance();
        if (j != null) {
            return j.getExtensionList(Descriptor.class);
        }
        ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
        for (IndexItem item : Index.load(Extension.class, Object.class)) {
            try {
                Object o = item.instance();
                if (!(o instanceof Descriptor)) continue;
                descriptors.add((Descriptor)o);
            }
            catch (InstantiationException x) {}
        }
        return descriptors;
    }

    public Map<String, Object> uninstantiate(T o) throws UnsupportedOperationException {
        T control;
        TreeMap<String, Object> r = new TreeMap<String, Object>();
        TreeMap<String, Object> constructorOnlyDataBoundProps = new TreeMap<String, Object>();
        for (DescribableParameter p : this.parameters.values()) {
            Object v = p.inspect(o);
            if (p.isRequired() && v == null) continue;
            r.put(p.getName(), v);
            if (!p.isRequired()) continue;
            constructorOnlyDataBoundProps.put(p.getName(), v);
        }
        try {
            control = this.instantiate(constructorOnlyDataBoundProps);
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Cannot create control version of " + this.type + " using " + constructorOnlyDataBoundProps, x);
            return r;
        }
        for (DescribableParameter p : this.parameters.values()) {
            Object v;
            if (p.isRequired() || !ObjectUtils.equals((Object)(v = p.inspect(control)), r.get(p.getName()))) continue;
            r.remove(p.getName());
        }
        return r;
    }

    public static Map<String, Object> uninstantiate_(Object o) {
        return new DescribableModel(o.getClass()).uninstantiate(o);
    }

    @CheckForNull
    public String getHelp() throws IOException {
        return this.getHelp("help.html");
    }

    @CheckForNull
    String getHelp(String name) throws IOException {
        for (Klass c = Klass.java(this.type); c != null; c = c.getSuperClass()) {
            URL u = c.getResource(name);
            if (u == null) continue;
            return IOUtils.toString((URL)u, (String)"UTF-8");
        }
        return null;
    }

    public String toString() {
        return "(" + StringUtils.join(this.getParameters(), (String)", ") + ")";
    }
}

