/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.console.ConsoleNote;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class BuildLogMultilineRegexMacro
extends DataBoundTokenMacro {
    public static final String MACRO_NAME = "BUILD_LOG_MULTILINE_REGEX";
    public static final int MAX_MATCHES_DEFAULT_VALUE = 0;
    @DataBoundTokenMacro.Parameter(required=true)
    public String regex;
    @DataBoundTokenMacro.Parameter
    public int maxMatches = 0;
    @DataBoundTokenMacro.Parameter
    public boolean showTruncatedLines = true;
    @DataBoundTokenMacro.Parameter
    public String substText = null;
    @DataBoundTokenMacro.Parameter
    public boolean escapeHtml = false;
    @DataBoundTokenMacro.Parameter
    public String matchedSegmentHtmlStyle = null;
    private static final Pattern LINE_TERMINATOR_PATTERN = Pattern.compile("(?<=.)\\r?\\n");

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    private boolean startPre(StringBuilder buffer, boolean insidePre) {
        if (!insidePre) {
            buffer.append("<pre>\n");
            insidePre = true;
        }
        return insidePre;
    }

    private boolean stopPre(StringBuilder buffer, boolean insidePre) {
        if (insidePre) {
            buffer.append("</pre>\n");
            insidePre = false;
        }
        return insidePre;
    }

    private void appendMatchedSegment(StringBuilder buffer, String segment, boolean escapeHtml, String style) {
        if (escapeHtml) {
            segment = StringEscapeUtils.escapeHtml((String)segment);
        }
        if (style != null) {
            buffer.append("<b");
            if (style.length() > 0) {
                buffer.append(" style=\"");
                buffer.append(style);
                buffer.append("\"");
            }
            buffer.append(">");
        }
        buffer.append(segment);
        if (style != null) {
            buffer.append("</b>");
        }
        buffer.append('\n');
    }

    private void appendLinesTruncated(StringBuilder buffer, int numLinesTruncated, boolean asHtml) {
        if (asHtml) {
            buffer.append("<p>");
        }
        buffer.append("[...truncated ");
        buffer.append(numLinesTruncated);
        buffer.append(" lines...]");
        if (asHtml) {
            buffer.append("</p>");
        }
        buffer.append('\n');
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> build, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)build, null, listener, macroName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String string;
        BufferedReader reader = new BufferedReader(run.getLogReader());
        try {
            string = this.getContent(reader);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex) {
                listener.error(ex.getMessage());
                return "";
            }
        }
        reader.close();
        return string;
    }

    private String getContent(BufferedReader reader) throws IOException {
        int numLinesTruncated;
        int ch;
        Pattern pattern = Pattern.compile(this.regex);
        boolean asHtml = this.matchedSegmentHtmlStyle != null;
        this.escapeHtml = asHtml || this.escapeHtml;
        StringBuilder line = new StringBuilder();
        StringBuilder fullLog = new StringBuilder();
        while ((ch = reader.read()) != -1) {
            if (ch == 13 || ch == 10) {
                if (line.length() > 0) {
                    fullLog.append(ConsoleNote.removeNotes((String)line.toString()));
                    line.setLength(0);
                }
                fullLog.append((char)ch);
                continue;
            }
            line.append((char)ch);
        }
        if (line.length() > 0) {
            fullLog.append(ConsoleNote.removeNotes((String)line.toString()));
        }
        StringBuilder content = new StringBuilder();
        int numMatches = 0;
        boolean insidePre = false;
        int lastMatchEnd = 0;
        Matcher matcher = pattern.matcher(fullLog);
        while (matcher.find() && (this.maxMatches == 0 || ++numMatches <= this.maxMatches)) {
            int numLinesTruncated2;
            if (this.showTruncatedLines && matcher.start() > lastMatchEnd && (numLinesTruncated2 = this.countLineTerminators(fullLog.subSequence(lastMatchEnd, matcher.start()))) > 0) {
                insidePre = this.stopPre(content, insidePre);
                this.appendLinesTruncated(content, numLinesTruncated2, asHtml);
            }
            if (asHtml) {
                insidePre = this.startPre(content, insidePre);
            }
            if (this.substText != null) {
                StringBuffer substBuf = new StringBuffer();
                matcher.appendReplacement(substBuf, this.substText);
                String segment = substBuf.substring(matcher.start() - lastMatchEnd);
                this.appendMatchedSegment(content, segment, this.escapeHtml, this.matchedSegmentHtmlStyle);
            } else {
                this.appendMatchedSegment(content, matcher.group(), this.escapeHtml, this.matchedSegmentHtmlStyle);
            }
            lastMatchEnd = matcher.end();
        }
        if (this.showTruncatedLines && fullLog.length() > lastMatchEnd && (numLinesTruncated = this.countLineTerminators(fullLog.subSequence(lastMatchEnd, fullLog.length()))) > 0) {
            insidePre = this.stopPre(content, insidePre);
            this.appendLinesTruncated(content, numLinesTruncated, asHtml);
        }
        this.stopPre(content, insidePre);
        return content.toString();
    }

    private int countLineTerminators(CharSequence charSequence) {
        int lineTerminatorCount = 0;
        Matcher matcher = LINE_TERMINATOR_PATTERN.matcher(charSequence);
        while (matcher.find()) {
            ++lineTerminatorCount;
        }
        return lineTerminatorCount;
    }
}

