/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class PropertyFromFileMacro
extends DataBoundTokenMacro {
    private static final String MACRO_NAME = "PROPFILE";
    @DataBoundTokenMacro.Parameter(required=true)
    public String file = null;
    @DataBoundTokenMacro.Parameter(required=true)
    public String property = null;

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, PropertyFromFileMacro.getWorkspace(context), listener, macroName);
    }

    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        String root = workspace.getRemote();
        return (String)workspace.act((Callable)new ReadProperty(root, this.file, this.property));
    }

    private static class ReadProperty
    extends MasterToSlaveCallable<String, IOException> {
        private String root;
        private String filename;
        private String property;

        public ReadProperty(String root, String filename, String property) {
            this.root = root;
            this.filename = filename;
            this.property = property;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String call() throws IOException {
            Properties props = new Properties();
            File file = new File(this.root, this.filename);
            String propertyValue = "";
            if (!file.exists()) return this.filename.concat(" not found");
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
            try (Reader resource = reader;){
                BufferedReader bReader = new BufferedReader(reader);
                resource = bReader;
                props.load(bReader);
                if (!props.containsKey(this.property)) return propertyValue;
                propertyValue = props.getProperty(this.property);
                return propertyValue;
            }
        }
    }
}

