/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class WorkspaceFileMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    public String path = "";
    @DataBoundTokenMacro.Parameter
    public String fileNotFoundMessage = "ERROR: File '%s' does not exist";
    @DataBoundTokenMacro.Parameter
    public int maxLines = -1;
    public static final String MACRO_NAME = "FILE";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, WorkspaceFileMacro.getWorkspace(context), listener, macroName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            EnvVars env = run.getEnvironment(listener);
            this.path = env.expand(this.path);
        }
        catch (Exception e) {
            listener.error("Error retrieving environment: %s", new Object[]{e.getMessage()});
        }
        if (!workspace.child(this.path).exists()) {
            return String.format(this.fileNotFoundMessage, this.path);
        }
        try {
            if (this.maxLines > 0) {
                StringBuilder result = new StringBuilder();
                try (BufferedReader reader = null;){
                    String line;
                    reader = new BufferedReader(new InputStreamReader(workspace.child(this.path).read(), Charset.defaultCharset()));
                    for (int lines = 0; lines < this.maxLines && (line = reader.readLine()) != null; ++lines) {
                        result.append(line);
                        result.append('\n');
                    }
                }
                return result.toString();
            }
            return workspace.child(this.path).readToString();
        }
        catch (IOException e) {
            return "ERROR: File '" + this.path + "' could not be read";
        }
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }
}

